/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFChainBlock;
import twilightforest.item.TFItems;

public class ItemTFChainBlock
extends ItemTool {
    private HashMap<ItemStack, Entity> launchedBlocksMap = new HashMap();

    protected ItemTFChainBlock() {
        super(6.0f, TFItems.TOOL_KNIGHTLY, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.stone}));
        this.maxStackSize = 1;
        this.setMaxDamage(99);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public ItemStack onItemRightClick(ItemStack stack, World worldObj, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        if (!worldObj.isRemote && !this.hasLaunchedBlock(stack)) {
            worldObj.playSoundAtEntity((Entity)player, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f));
            EntityTFChainBlock launchedBlock = new EntityTFChainBlock(worldObj, (EntityLivingBase)player);
            worldObj.spawnEntityInWorld((Entity)launchedBlock);
            this.setLaunchedBlock(stack, launchedBlock);
            ItemTFChainBlock.setChainAsThrown(stack);
            stack.damageItem(1, (EntityLivingBase)player);
        }
        return stack;
    }

    public static void setChainAsThrown(ItemStack stack) {
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setBoolean("thrown", true);
    }

    public static void setChainAsReturned(ItemStack stack) {
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setBoolean("thrown", false);
    }

    public static boolean doesChainHaveBlock(ItemStack stack) {
        if (stack.getTagCompound() == null) {
            return true;
        }
        return !stack.getTagCompound().getBoolean("thrown");
    }

    public static void setChainAsReturned(EntityPlayer player) {
        if (player != null && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() == TFItems.chainBlock) {
            ItemTFChainBlock.setChainAsReturned(player.getCurrentEquippedItem());
        }
    }

    public boolean hasLaunchedBlock(ItemStack stack) {
        Entity cube = this.launchedBlocksMap.get(stack);
        return cube != null && !cube.isDead;
    }

    public void setLaunchedBlock(ItemStack stack, EntityTFChainBlock launchedCube) {
        this.launchedBlocksMap.put(stack, (Entity)launchedCube);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (ItemTFChainBlock.doesChainHaveBlock(stack)) {
            return this.itemIcon;
        }
        return TFItems.knightmetalRing.getIconIndex(stack);
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (toolClass != null && toolClass.equals("pickaxe")) {
            return 2;
        }
        return -1;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.getItem() == TFItems.knightMetal ? true : super.getIsRepairable(par1ItemStack, par2ItemStack);
    }
}

