/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFCrumbleHorn
extends ItemTF {
    private static final int CHANCE_HARVEST = 20;
    private static final int CHANCE_CRUMBLE = 5;

    protected ItemTFCrumbleHorn() {
        this.setCreativeTab(TFItems.creativeTab);
        this.maxStackSize = 1;
        this.setMaxDamage(1024);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World world, EntityPlayer player) {
        player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        world.playSoundAtEntity((Entity)player, "mob.sheep.say", 1.0f, 0.8f);
        return par1ItemStack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count > 10 && count % 5 == 0 && !player.worldObj.isRemote) {
            int crumbled = this.doCrumble(player.worldObj, player);
            if (crumbled > 0) {
                stack.damageItem(crumbled, (EntityLivingBase)player);
            }
            player.worldObj.playSoundAtEntity((Entity)player, "mob.sheep.say", 1.0f, 0.8f);
        }
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    private int doCrumble(World world, EntityPlayer player) {
        double range = 3.0;
        double radius = 2.0;
        Vec3 srcVec = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 lookVec = player.getLookVec();
        Vec3 destVec = srcVec.addVector(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range);
        AxisAlignedBB crumbleBox = AxisAlignedBB.getBoundingBox((double)(destVec.xCoord - radius), (double)(destVec.yCoord - radius), (double)(destVec.zCoord - radius), (double)(destVec.xCoord + radius), (double)(destVec.yCoord + radius), (double)(destVec.zCoord + radius));
        return this.crumbleBlocksInAABB(world, player, crumbleBox);
    }

    private int crumbleBlocksInAABB(World world, EntityPlayer player, AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        int crumbled = 0;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    crumbled += this.crumbleBlock(world, player, dx, dy, dz);
                }
            }
        }
        return crumbled;
    }

    private int crumbleBlock(World world, EntityPlayer player, int dx, int dy, int dz) {
        int cost = 0;
        Block currentID = world.getBlock(dx, dy, dz);
        if (currentID != Blocks.air) {
            int currentMeta = world.getBlockMetadata(dx, dy, dz);
            if (currentID == Blocks.stone && world.rand.nextInt(5) == 0) {
                world.setBlock(dx, dy, dz, Blocks.cobblestone, 0, 3);
                world.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
                ++cost;
            }
            if (currentID == Blocks.stonebrick && currentMeta == 0 && world.rand.nextInt(5) == 0) {
                world.setBlock(dx, dy, dz, Blocks.stonebrick, 2, 3);
                world.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
                ++cost;
            }
            if (currentID == TFBlocks.mazestone && currentMeta == 1 && world.rand.nextInt(5) == 0) {
                world.setBlock(dx, dy, dz, TFBlocks.mazestone, 4, 3);
                world.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
                ++cost;
            }
            if (currentID == Blocks.cobblestone && world.rand.nextInt(5) == 0) {
                world.setBlock(dx, dy, dz, Blocks.gravel, 0, 3);
                world.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
                ++cost;
            }
            if ((currentID == Blocks.gravel || currentID == Blocks.dirt) && currentID.canHarvestBlock(player, currentMeta) && world.rand.nextInt(20) == 0) {
                world.setBlock(dx, dy, dz, Blocks.air, 0, 3);
                currentID.harvestBlock(world, player, dx, dy, dz, currentMeta);
                world.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
                ++cost;
            }
        }
        return cost;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

