/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import twilightforest.TFAchievementPage;
import twilightforest.TFMagicMapData;
import twilightforest.TwilightForestMod;
import twilightforest.item.TFItems;

public class ItemTFEmptyMagicMap
extends ItemMapBase {
    protected ItemTFEmptyMagicMap() {
        this.setCreativeTab(TFItems.creativeTab);
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.provider.dimensionId != TwilightForestMod.dimensionID) {
            return itemStack;
        }
        ItemStack mapItem = new ItemStack(TFItems.magicMap, 1, world.getUniqueDataId("magicmap"));
        String mapName = "magicmap_" + mapItem.getItemDamage();
        TFMagicMapData mapData = new TFMagicMapData(mapName);
        world.setItemData(mapName, (WorldSavedData)mapData);
        mapData.scale = (byte)4;
        int step = 128 * (1 << mapData.scale);
        mapData.xCenter = (int)(Math.round(player.posX / (double)step) * (long)step);
        mapData.zCenter = (int)(Math.round(player.posZ / (double)step) * (long)step);
        mapData.dimension = (byte)world.provider.dimensionId;
        mapData.markDirty();
        --itemStack.stackSize;
        if (mapItem.getItem() == TFItems.magicMap) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightMagicMap);
        }
        if (itemStack.stackSize <= 0) {
            return mapItem;
        }
        if (!player.inventory.addItemStackToInventory(mapItem.copy())) {
            player.dropPlayerItemWithRandomChoice(mapItem, false);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

