/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFMazeMapData;
import twilightforest.TwilightForestMod;
import twilightforest.item.TFItems;
import twilightforest.world.WorldProviderTwilightForest;

public class ItemTFEmptyMazeMap
extends ItemMapBase {
    boolean mapOres;

    protected ItemTFEmptyMazeMap(boolean mapOres) {
        this.setCreativeTab(TFItems.creativeTab);
        this.mapOres = mapOres;
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.provider.dimensionId != TwilightForestMod.dimensionID) {
            return itemStack;
        }
        ItemStack mapItem = new ItemStack(this.mapOres ? TFItems.oreMap : TFItems.mazeMap, 1, world.getUniqueDataId("mazemap"));
        String var5 = "mazemap_" + mapItem.getItemDamage();
        TFMazeMapData mapData = new TFMazeMapData(var5);
        world.setItemData(var5, (WorldSavedData)mapData);
        mapData.scale = 0;
        int step = 128 * (1 << mapData.scale);
        if (world.provider instanceof WorldProviderTwilightForest && TFFeature.getFeatureForRegion(MathHelper.floor_double((double)player.posX) >> 4, MathHelper.floor_double((double)player.posZ) >> 4, world) == TFFeature.labyrinth) {
            ChunkCoordinates mc = TFFeature.getNearestCenterXYZ(MathHelper.floor_double((double)player.posX) >> 4, MathHelper.floor_double((double)player.posZ) >> 4, world);
            mapData.xCenter = mc.posX;
            mapData.zCenter = mc.posZ;
            mapData.yCenter = MathHelper.floor_double((double)player.posY);
        } else {
            mapData.xCenter = (int)(Math.round(player.posX / (double)step) * (long)step) + 10;
            mapData.zCenter = (int)(Math.round(player.posZ / (double)step) * (long)step) + 10;
            mapData.yCenter = MathHelper.floor_double((double)player.posY);
        }
        mapData.dimension = world.provider.dimensionId;
        mapData.markDirty();
        --itemStack.stackSize;
        if (mapItem.getItem() == TFItems.mazeMap) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightMazeMap);
        }
        if (mapItem.getItem() == TFItems.oreMap) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightOreMap);
        }
        if (itemStack.stackSize <= 0) {
            return mapItem;
        }
        if (!player.inventory.addItemStackToInventory(mapItem.copy())) {
            player.dropPlayerItemWithRandomChoice(mapItem, false);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

