/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import twilightforest.block.BlockTFGiantBlock;
import twilightforest.block.TFBlocks;
import twilightforest.item.GiantItemIcon;
import twilightforest.item.TFItems;

public class ItemTFGiantPick
extends ItemPickaxe {
    private float damageVsEntity;
    private GiantItemIcon giantIcon;

    protected ItemTFGiantPick(Item.ToolMaterial par2EnumToolMaterial) {
        super(par2EnumToolMaterial);
        this.setCreativeTab(TFItems.creativeTab);
        this.damageVsEntity = 4.0f + par2EnumToolMaterial.getDamageVsEntity();
    }

    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.getItem() == TFItems.knightMetal ? true : super.getIsRepairable(par1ItemStack, par2ItemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = Items.stone_pickaxe.getIconFromDamage(0);
        this.giantIcon = new GiantItemIcon(this.itemIcon, 0.4375f, 0.125f);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == -1) {
            return this.giantIcon;
        }
        return super.getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.addInformation(par1ItemStack, par2EntityPlayer, par3List, par4);
        par3List.add(StatCollector.translateToLocal((String)(this.getUnlocalizedName() + ".tooltip")));
    }

    public Multimap getItemAttributeModifiers() {
        Multimap multimap = super.getItemAttributeModifiers();
        multimap.removeAll((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName());
        multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.damageVsEntity, 0));
        return multimap;
    }

    public float func_150893_a(ItemStack par1ItemStack, Block par2Block) {
        float strVsBlock = super.func_150893_a(par1ItemStack, par2Block);
        return this.isGiantBlock(par2Block) ? strVsBlock * 64.0f : (strVsBlock *= par2Block == TFBlocks.giantObsidian ? 64.0f : 1.0f);
    }

    private boolean isGiantBlock(Block block) {
        return block instanceof BlockTFGiantBlock;
    }
}

