/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTF;
import twilightforest.world.WorldProviderTwilightForest;

public class ItemTFMagicBeans
extends ItemTF {
    public ItemTFMagicBeans() {
        this.makeRare();
    }

    public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block blockAt = world.getBlock(x, y, z);
        int minY = y + 1;
        int maxY = Math.max(y + 100, (int)(this.getCloudHeight(world) + 25.0f));
        if (y < maxY && blockAt == TFBlocks.uberousSoil) {
            if (!world.isRemote) {
                this.makeHugeStalk(world, x, z, minY, maxY);
            }
            return true;
        }
        return false;
    }

    private float getCloudHeight(World world) {
        if (world.provider instanceof WorldProviderTwilightForest) {
            return ((WorldProviderTwilightForest)world.provider).getCloudHeight();
        }
        try {
            return world.provider.getCloudHeight();
        }
        catch (NoSuchMethodError nsme) {
            return world.provider.terrainType.getCloudHeight();
        }
    }

    private void makeHugeStalk(World world, int x, int z, int minY, int maxY) {
        int yOffset = world.rand.nextInt(100);
        float cScale = world.rand.nextFloat() * 0.25f + 0.125f;
        float rScale = world.rand.nextFloat() * 0.25f + 0.125f;
        float radius = 4.0f + MathHelper.sin((float)((float)(minY + yOffset) * rScale)) * 3.0f;
        x = (int)((float)x - MathHelper.sin((float)((float)(minY + yOffset) * cScale)) * radius);
        z = (int)((float)z - MathHelper.cos((float)((float)(minY + yOffset) * cScale)) * radius);
        int nextLeafY = minY + 10 + world.rand.nextInt(20);
        boolean isClear = true;
        for (int dy = minY; dy < maxY && isClear; ++dy) {
            radius = 5.0f + MathHelper.sin((float)((float)(dy + yOffset) * rScale)) * 2.5f;
            float cx = (float)x + MathHelper.sin((float)((float)(dy + yOffset) * cScale)) * radius;
            float cz = (float)z + MathHelper.cos((float)((float)(dy + yOffset) * cScale)) * radius;
            float stalkThickness = 2.5f;
            if (maxY - dy < 5) {
                stalkThickness *= (float)(maxY - dy) / 5.0f;
            }
            int minX = MathHelper.floor_float((float)((float)x - radius - stalkThickness));
            int maxX = MathHelper.ceiling_float_int((float)((float)x + radius + stalkThickness));
            int minZ = MathHelper.floor_float((float)((float)z - radius - stalkThickness));
            int maxZ = MathHelper.ceiling_float_int((float)((float)z + radius + stalkThickness));
            for (int dx = minX; dx < maxX; ++dx) {
                for (int dz = minZ; dz < maxZ; ++dz) {
                    if (!(((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz) < stalkThickness * stalkThickness)) continue;
                    isClear &= this.tryToPlaceStalk(world, dx, dy, dz);
                }
            }
            if (dy != nextLeafY) continue;
            int lx = (int)((float)x + MathHelper.sin((float)((float)(dy + yOffset) * cScale)) * (radius + stalkThickness));
            int lz = (int)((float)z + MathHelper.cos((float)((float)(dy + yOffset) * cScale)) * (radius + stalkThickness));
            this.placeLeaves(world, lx, dy, lz);
            nextLeafY = dy + 5 + world.rand.nextInt(10);
        }
    }

    private void placeLeaves(World world, int x, int y, int z) {
        int dz;
        int dx;
        world.setBlock(x, y, z, TFBlocks.hugeStalk);
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                this.tryToPlaceLeaves(world, x + dx, y - 1, z + dz);
                this.tryToPlaceLeaves(world, x + dx, y + 1, z + dz);
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if ((dx == 2 || dx == -2) && (dz == 2 || dz == -2)) continue;
                this.tryToPlaceLeaves(world, x + dx, y + 0, z + dz);
            }
        }
    }

    private boolean tryToPlaceStalk(World world, int x, int y, int z) {
        Block blockThere = world.getBlock(x, y, z);
        if (blockThere == Blocks.air || blockThere.isReplaceable((IBlockAccess)world, x, y, z) || blockThere.canBeReplacedByLeaves((IBlockAccess)world, x, y, z) || blockThere.isLeaves((IBlockAccess)world, x, y, z) || blockThere.canSustainLeaves((IBlockAccess)world, x, y, z)) {
            world.setBlock(x, y, z, TFBlocks.hugeStalk);
            return true;
        }
        return false;
    }

    private void tryToPlaceLeaves(World world, int x, int y, int z) {
        Block blockThere = world.getBlock(x, y, z);
        if (blockThere == Blocks.air || blockThere.canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) {
            world.setBlock(x, y, z, TFBlocks.leaves3, 1, 2);
        }
    }
}

