/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.MapData;
import twilightforest.TFFeature;
import twilightforest.TFMagicMapData;
import twilightforest.TFMapPacketHandler;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.world.TFWorldChunkManager;

public class ItemTFMagicMap
extends ItemMap {
    public static final String STR_ID = "magicmap";

    protected ItemTFMagicMap() {
    }

    @SideOnly(value=Side.CLIENT)
    public static TFMagicMapData getMPMapData(int par0, World world) {
        String mapName = "magicmap_" + par0;
        TFMagicMapData mapData = (TFMagicMapData)world.loadItemData(TFMagicMapData.class, mapName);
        if (mapData == null) {
            mapData = new TFMagicMapData(mapName);
            world.setItemData(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public TFMagicMapData getMapData(ItemStack itemStack, World world) {
        String mapName = "magicmap_" + itemStack.getItemDamage();
        TFMagicMapData mapData = (TFMagicMapData)world.loadItemData(TFMagicMapData.class, mapName);
        if (mapData == null && !world.isRemote) {
            itemStack.setItemDamage(world.getUniqueDataId(STR_ID));
            mapName = "magicmap_" + itemStack.getItemDamage();
            mapData = new TFMagicMapData(mapName);
            mapData.xCenter = world.getWorldInfo().getSpawnX();
            mapData.zCenter = world.getWorldInfo().getSpawnZ();
            mapData.scale = (byte)4;
            mapData.dimension = world.provider.dimensionId;
            mapData.markDirty();
            world.setItemData(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public void updateMapData(World world, Entity entity, TFMagicMapData mapData) {
        if (world.provider.dimensionId == mapData.dimension && entity instanceof EntityPlayer) {
            int xSize = 128;
            int zSize = 128;
            int scaleFactor = 1 << mapData.scale;
            int xCenter = mapData.xCenter;
            int zCenter = mapData.zCenter;
            int xDraw = MathHelper.floor_double((double)(entity.posX - (double)xCenter)) / scaleFactor + xSize / 2;
            int zDraw = MathHelper.floor_double((double)(entity.posZ - (double)zCenter)) / scaleFactor + zSize / 2;
            int drawSize = 512 / scaleFactor;
            MapData.MapInfo mapInfo = mapData.func_82568_a((EntityPlayer)entity);
            ++mapInfo.field_82569_d;
            for (int xStep = xDraw - drawSize + 1; xStep < xDraw + drawSize; ++xStep) {
                if ((xStep & 0xF) != (mapInfo.field_82569_d & 0xF)) continue;
                int highNumber = 255;
                int lowNumber = 0;
                for (int zStep = zDraw - drawSize - 1; zStep < zDraw + drawSize; ++zStep) {
                    byte existingColor;
                    if (xStep < 0 || zStep < -1 || xStep >= xSize || zStep >= zSize) continue;
                    int xOffset = xStep - xDraw;
                    int zOffset = zStep - zDraw;
                    boolean var20 = xOffset * xOffset + zOffset * zOffset > (drawSize - 2) * (drawSize - 2);
                    int xDraw2 = (xCenter / scaleFactor + xStep - xSize / 2) * scaleFactor;
                    int zDraw2 = (zCenter / scaleFactor + zStep - zSize / 2) * scaleFactor;
                    int[] biomeFrequencies = new int[256];
                    for (int xStep2 = 0; xStep2 < scaleFactor; ++xStep2) {
                        for (int zStep2 = 0; zStep2 < scaleFactor; ++zStep2) {
                            TFWorldChunkManager tfManager;
                            int biomeID;
                            int n = biomeID = world.getBiomeGenForCoords((int)(xDraw2 + xStep2), (int)(zDraw2 + zStep2)).biomeID;
                            biomeFrequencies[n] = biomeFrequencies[n] + 1;
                            if (biomeID == BiomeGenBase.river.biomeID || biomeID == TFBiomeBase.stream.biomeID) {
                                int n2 = biomeID;
                                biomeFrequencies[n2] = biomeFrequencies[n2] + 2;
                            }
                            if (!(world.getWorldChunkManager() instanceof TFWorldChunkManager) || !(tfManager = (TFWorldChunkManager)world.getWorldChunkManager()).isInFeatureChunk(world, xDraw2 + xStep2, zDraw2 + zStep2) || zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize) continue;
                            mapData.addFeatureToMap(TFFeature.getNearestFeature(xDraw2 + xStep2 >> 4, zDraw2 + zStep2 >> 4, world), xDraw2, zDraw2);
                        }
                    }
                    byte biomeIDToShow = 0;
                    int highestFrequency = 0;
                    for (int i = 0; i < 256; ++i) {
                        if (biomeFrequencies[i] <= highestFrequency) continue;
                        biomeIDToShow = (byte)i;
                        highestFrequency = biomeFrequencies[i];
                    }
                    biomeIDToShow = (byte)(biomeIDToShow + 1);
                    if (zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize || var20 && (xStep + zStep & 1) == 0 || (existingColor = mapData.colors[xStep + zStep * xSize]) == biomeIDToShow) continue;
                    if (highNumber > zStep) {
                        highNumber = zStep;
                    }
                    if (lowNumber < zStep) {
                        lowNumber = zStep;
                    }
                    mapData.colors[xStep + zStep * xSize] = biomeIDToShow;
                }
                if (highNumber > lowNumber) continue;
                mapData.setColumnDirty(xStep, highNumber, lowNumber);
            }
        }
    }

    public void onUpdate(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (!world.isRemote) {
            TFMagicMapData mapData = this.getMapData(itemStack, world);
            if (entity instanceof EntityPlayer) {
                EntityPlayer var7 = (EntityPlayer)entity;
                mapData.updateVisiblePlayers(var7, itemStack);
            }
            if (par5) {
                this.updateMapData(world, entity, mapData);
            }
        }
    }

    public void onCreated(ItemStack itemStack, World world, EntityPlayer player) {
    }

    public EnumRarity getRarity(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public boolean hasEffect(ItemStack itemStack) {
        return false;
    }

    public Packet func_150911_c(ItemStack itemStack, World world, EntityPlayer player) {
        byte[] mapBytes = this.getMapData(itemStack, world).getUpdatePacketData(itemStack, world, player);
        if (mapBytes == null) {
            return null;
        }
        if (mapBytes[0] == 1 && world.rand.nextInt(4) == 0) {
            this.getMapData(itemStack, world).checkExistingFeatures(world);
            mapBytes = this.getMapData(itemStack, world).makeFeatureStorageArray();
        }
        short uniqueID = (short)itemStack.getItemDamage();
        return TFMapPacketHandler.makeMagicMapPacket(STR_ID, uniqueID, mapBytes);
    }

    public String getItemStackDisplayName(ItemStack itemStack) {
        return String.valueOf(StatCollector.translateToLocal((String)(this.getUnlocalizedNameInefficiently(itemStack) + ".name")) + " #" + itemStack.getItemDamage()).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

