/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import twilightforest.TFMapPacketHandler;
import twilightforest.TFMazeMapData;

public class ItemTFMazeMap
extends ItemMap {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected boolean mapOres;

    protected ItemTFMazeMap(boolean par2MapOres) {
        this.mapOres = par2MapOres;
    }

    @SideOnly(value=Side.CLIENT)
    public static TFMazeMapData getMPMapData(int par0, World par1World) {
        String mapName = "mazemap_" + par0;
        TFMazeMapData mapData = (TFMazeMapData)par1World.loadItemData(TFMazeMapData.class, mapName);
        if (mapData == null) {
            mapData = new TFMazeMapData(mapName);
            par1World.setItemData(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public TFMazeMapData getMapData(ItemStack par1ItemStack, World par2World) {
        TFMazeMapData mapData = (TFMazeMapData)par2World.loadItemData(TFMazeMapData.class, "mazemap_" + par1ItemStack.getItemDamage());
        if (mapData == null && !par2World.isRemote) {
            par1ItemStack.setItemDamage(par2World.getUniqueDataId(STR_ID));
            String mapName = "mazemap_" + par1ItemStack.getItemDamage();
            mapData = new TFMazeMapData(mapName);
            mapData.xCenter = par2World.getWorldInfo().getSpawnX();
            mapData.zCenter = par2World.getWorldInfo().getSpawnZ();
            mapData.scale = 0;
            mapData.dimension = par2World.provider.dimensionId;
            mapData.markDirty();
            par2World.setItemData(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public void updateMapData(World par1World, Entity par2Entity, TFMazeMapData par3MapData) {
        int yDraw = MathHelper.floor_double((double)(par2Entity.posY - (double)par3MapData.yCenter));
        if (par1World.provider.dimensionId == par3MapData.dimension && yDraw > -3 && yDraw < 3) {
            int xSize = 128;
            int zSize = 128;
            int xCenter = par3MapData.xCenter;
            int zCenter = par3MapData.zCenter;
            int xDraw = MathHelper.floor_double((double)(par2Entity.posX - (double)xCenter)) + xSize / 2;
            int zDraw = MathHelper.floor_double((double)(par2Entity.posZ - (double)zCenter)) + zSize / 2;
            int drawSize = 16;
            MapData.MapInfo mapInfo = par3MapData.func_82568_a((EntityPlayer)par2Entity);
            ++mapInfo.field_82569_d;
            for (int xStep = xDraw - drawSize + 1; xStep < xDraw + drawSize; ++xStep) {
                if ((xStep & 0xF) != (mapInfo.field_82569_d & 0xF)) continue;
                int highNumber = 255;
                int lowNumber = 0;
                for (int zStep = zDraw - drawSize - 1; zStep < zDraw + drawSize; ++zStep) {
                    byte tintedColor;
                    byte existingColor;
                    if (xStep < 0 || zStep < -1 || xStep >= xSize || zStep >= zSize) continue;
                    int xOffset = xStep - xDraw;
                    int zOffset = zStep - zDraw;
                    boolean var20 = xOffset * xOffset + zOffset * zOffset > (drawSize - 2) * (drawSize - 2);
                    int xDraw2 = xCenter + xStep - xSize / 2;
                    int zDraw2 = zCenter + zStep - zSize / 2;
                    Chunk chunk = par1World.getChunkFromBlockCoords(xDraw2, zDraw2);
                    int x15 = xDraw2 & 0xF;
                    int z15 = zDraw2 & 0xF;
                    int heightValue = par3MapData.yCenter;
                    Block blockID = chunk.getBlock(x15, heightValue, z15);
                    int tint = 1;
                    int colorIndex = 0;
                    if (blockID == Blocks.stone && this.mapOres) {
                        for (int i = -3; i <= 3; ++i) {
                            Block searchID = chunk.getBlock(x15, heightValue + i, z15);
                            if (searchID == Blocks.stone) continue;
                            blockID = searchID;
                            if (i > 0) {
                                tint = 2;
                            }
                            if (i >= 0) break;
                            tint = 0;
                            break;
                        }
                    }
                    if (blockID != Blocks.air) {
                        MapColor mapColor = blockID.getMaterial().getMaterialMapColor();
                        colorIndex = mapColor.colorIndex;
                    }
                    if (this.mapOres) {
                        if (blockID == Blocks.coal_ore) {
                            colorIndex = MapColor.obsidianColor.colorIndex;
                        } else if (blockID == Blocks.gold_ore) {
                            colorIndex = MapColor.goldColor.colorIndex;
                        } else if (blockID == Blocks.iron_ore) {
                            colorIndex = MapColor.ironColor.colorIndex;
                        } else if (blockID == Blocks.lapis_ore) {
                            colorIndex = MapColor.lapisColor.colorIndex;
                        } else if (blockID == Blocks.redstone_ore || blockID == Blocks.lit_redstone_ore) {
                            colorIndex = MapColor.redColor.colorIndex;
                        } else if (blockID == Blocks.diamond_ore) {
                            colorIndex = MapColor.diamondColor.colorIndex;
                        } else if (blockID == Blocks.emerald_ore) {
                            colorIndex = MapColor.emeraldColor.colorIndex;
                        } else if (blockID != Blocks.air && blockID.getUnlocalizedName().toLowerCase().contains("ore")) {
                            colorIndex = MapColor.pinkColor.colorIndex;
                        }
                    }
                    if (zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize || var20 && (xStep + zStep & 1) == 0 || (existingColor = par3MapData.colors[xStep + zStep * xSize]) == (tintedColor = (byte)(colorIndex * 4 + tint))) continue;
                    if (highNumber > zStep) {
                        highNumber = zStep;
                    }
                    if (lowNumber < zStep) {
                        lowNumber = zStep;
                    }
                    par3MapData.colors[xStep + zStep * xSize] = tintedColor;
                }
                if (highNumber > lowNumber) continue;
                par3MapData.setColumnDirty(xStep, highNumber, lowNumber);
            }
        }
    }

    public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean isActiveItem) {
        if (!par2World.isRemote) {
            TFMazeMapData mapData = this.getMapData(par1ItemStack, par2World);
            if (par3Entity instanceof EntityPlayer) {
                MapData.MapCoord mapCoord;
                EntityPlayer player = (EntityPlayer)par3Entity;
                mapData.updateVisiblePlayers(player, par1ItemStack);
                int yProximity = MathHelper.floor_double((double)(player.posY - (double)mapData.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (mapCoord = (MapData.MapCoord)mapData.playersVisibleOnMap.get(player.getCommandSenderName())) != null) {
                    mapCoord.iconSize = (byte)6;
                }
            }
            if (isActiveItem) {
                this.updateMapData(par2World, par3Entity, mapData);
            }
        }
    }

    public void onCreated(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par1ItemStack.setItemDamage(par2World.getUniqueDataId(STR_ID));
        String mapName = "mazemap_" + par1ItemStack.getItemDamage();
        TFMazeMapData mapData = new TFMazeMapData(mapName);
        par2World.setItemData(mapName, (WorldSavedData)mapData);
        mapData.xCenter = MathHelper.floor_double((double)par3EntityPlayer.posX);
        mapData.yCenter = MathHelper.floor_double((double)par3EntityPlayer.posY);
        mapData.zCenter = MathHelper.floor_double((double)par3EntityPlayer.posZ);
        mapData.scale = 0;
        mapData.dimension = par2World.provider.dimensionId;
        mapData.markDirty();
    }

    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return this.mapOres ? EnumRarity.epic : EnumRarity.uncommon;
    }

    public boolean hasEffect(ItemStack itemStack) {
        return false;
    }

    public Packet func_150911_c(ItemStack itemStack, World world, EntityPlayer player) {
        byte[] mapBytes = this.getMapData(itemStack, world).getUpdatePacketData(itemStack, world, player);
        if (mapBytes == null) {
            return null;
        }
        short uniqueID = (short)itemStack.getItemDamage();
        return TFMapPacketHandler.makeMagicMapPacket(STR_ID, uniqueID, mapBytes);
    }

    public String getItemStackDisplayName(ItemStack itemStack) {
        return String.valueOf(StatCollector.translateToLocal((String)(this.getUnlocalizedNameInefficiently(itemStack) + ".name")) + " #" + itemStack.getItemDamage()).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

