/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;
import twilightforest.world.TFGenerator;

public class ItemTFOreMagnet
extends ItemTF {
    private static final float WIGGLE = 10.0f;
    private IIcon[] icons;
    private String[] iconNames = new String[]{"oreMagnet", "oreMagnet1", "oreMagnet2"};
    private static final HashSet<Integer[]> FOUND_ORE_BLOCKS = new HashSet();
    private static final int MAX_FIND_VEIN_RECURSION_DEPTH = 24;

    protected ItemTFOreMagnet() {
        this.setCreativeTab(TFItems.creativeTab);
        this.maxStackSize = 1;
        this.setMaxDamage(12);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World world, EntityPlayer player) {
        player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        return par1ItemStack;
    }

    public void onPlayerStoppedUsing(ItemStack par1ItemStack, World world, EntityPlayer player, int useRemaining) {
        int useTime = this.getMaxItemUseDuration(par1ItemStack) - useRemaining;
        if (!world.isRemote && useTime > 10) {
            int moved = this.doMagnet(world, player, 0.0f, 0.0f);
            if (moved == 0) {
                moved = this.doMagnet(world, player, 10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 0.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, -10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, -10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, -10.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 0.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, player, 10.0f, -10.0f);
            }
            if (moved > 0) {
                par1ItemStack.damageItem(moved, (EntityLivingBase)player);
                if (par1ItemStack.stackSize == 0) {
                    player.destroyCurrentEquippedItem();
                }
                world.playSoundAtEntity((Entity)player, "mob.endermen.portal", 1.0f, 1.0f);
            }
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem != null && usingItem.getItem() == this) {
            int useTime = usingItem.getMaxItemUseDuration() - useRemaining;
            if (useTime >= 20) {
                return (useTime >> 2) % 2 == 0 ? this.icons[2] : this.icons[1];
            }
            if (useTime > 10) {
                return this.icons[1];
            }
        }
        return this.icons[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        super.registerIcons(par1IconRegister);
        this.icons = new IIcon[this.iconNames.length];
        for (int i = 0; i < this.iconNames.length; ++i) {
            this.icons[i] = par1IconRegister.registerIcon("TwilightForest:" + this.iconNames[i]);
        }
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    protected int doMagnet(World world, EntityPlayer player, float yawOffset, float pitchOffset) {
        double range = 32.0;
        Vec3 srcVec = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 lookVec = this.getOffsetLook(player, yawOffset, pitchOffset);
        Vec3 destVec = srcVec.addVector(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range);
        int useX = MathHelper.floor_double((double)srcVec.xCoord);
        int useY = MathHelper.floor_double((double)srcVec.yCoord);
        int useZ = MathHelper.floor_double((double)srcVec.zCoord);
        int destX = MathHelper.floor_double((double)destVec.xCoord);
        int destY = MathHelper.floor_double((double)destVec.yCoord);
        int destZ = MathHelper.floor_double((double)destVec.zCoord);
        return ItemTFOreMagnet.doMagnet(world, useX, useY, useZ, destX, destY, destZ);
    }

    public static int doMagnet(World world, int useX, int useY, int useZ, int destX, int destY, int destZ) {
        int blocksMoved = 0;
        ChunkCoordinates[] lineArray = TFGenerator.getBresehnamArrayCoords(useX, useY, useZ, destX, destY, destZ);
        Block foundID = Blocks.air;
        int foundMeta = -1;
        int foundX = -1;
        int foundY = -1;
        int foundZ = -1;
        int baseX = -1;
        int baseY = -1;
        int baseZ = -1;
        boolean isNetherrack = false;
        for (ChunkCoordinates coord : lineArray) {
            Block searchID = world.getBlock(coord.posX, coord.posY, coord.posZ);
            int searchMeta = world.getBlockMetadata(coord.posX, coord.posY, coord.posZ);
            if (baseY == -1) {
                if (ItemTFOreMagnet.isReplaceable(world, searchID, searchMeta, coord.posX, coord.posY, coord.posZ)) {
                    baseX = coord.posX;
                    baseY = coord.posY;
                    baseZ = coord.posZ;
                } else if (ItemTFOreMagnet.isNetherReplaceable(world, searchID, searchMeta, coord.posX, coord.posY, coord.posZ)) {
                    isNetherrack = true;
                    baseX = coord.posX;
                    baseY = coord.posY;
                    baseZ = coord.posZ;
                }
            }
            if (searchID == Blocks.air || !ItemTFOreMagnet.isOre(searchID, searchMeta)) continue;
            foundID = searchID;
            foundMeta = searchMeta;
            foundX = coord.posX;
            foundY = coord.posY;
            foundZ = coord.posZ;
            FOUND_ORE_BLOCKS.add(new Integer[]{Block.getIdFromBlock((Block)foundID), foundMeta});
            break;
        }
        if (baseY != -1 && foundID != Blocks.air) {
            HashMap<ChunkCoordinates, Optional<TileEntity>> veinBlocks = new HashMap<ChunkCoordinates, Optional<TileEntity>>();
            ItemTFOreMagnet.findVein(world, foundX, foundY, foundZ, foundID, foundMeta, veinBlocks);
            int offX = baseX - foundX;
            int offY = baseY - foundY;
            int offZ = baseZ - foundZ;
            for (Map.Entry<ChunkCoordinates, Optional<TileEntity>> entry : veinBlocks.entrySet()) {
                ChunkCoordinates coord = entry.getKey();
                int replaceX = coord.posX + offX;
                int replaceY = coord.posY + offY;
                int replaceZ = coord.posZ + offZ;
                Block replaceID = world.getBlock(replaceX, replaceY, replaceZ);
                int replaceMeta = world.getBlockMetadata(replaceX, replaceY, replaceZ);
                if (!(!isNetherrack ? ItemTFOreMagnet.isReplaceable(world, replaceID, replaceMeta, replaceX, replaceY, replaceZ) : ItemTFOreMagnet.isNetherReplaceable(world, replaceID, replaceMeta, replaceX, replaceY, replaceZ)) && replaceID != Blocks.air) continue;
                world.setBlock(coord.posX, coord.posY, coord.posZ, isNetherrack ? Blocks.netherrack : Blocks.stone, 0, 2);
                world.setBlock(replaceX, replaceY, replaceZ, foundID, foundMeta, 2);
                entry.getValue().ifPresent(tile -> {
                    tile.xCoord = replaceX;
                    tile.yCoord = replaceY;
                    tile.zCoord = replaceZ;
                    tile.validate();
                    world.setTileEntity(replaceX, replaceY, replaceZ, tile);
                    world.removeTileEntity(coord.posX, coord.posY, coord.posZ);
                    tile.validate();
                    tile.markDirty();
                });
                ++blocksMoved;
            }
        }
        return blocksMoved;
    }

    private Vec3 getOffsetLook(EntityPlayer player, float yawOffset, float pitchOffset) {
        float var2 = MathHelper.cos((float)(-(player.rotationYaw + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var3 = MathHelper.sin((float)(-(player.rotationYaw + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -MathHelper.cos((float)(-(player.rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        float var5 = MathHelper.sin((float)(-(player.rotationPitch + pitchOffset) * ((float)Math.PI / 180)));
        return Vec3.createVectorHelper((double)(var3 * var4), (double)var5, (double)(var2 * var4));
    }

    private static boolean isReplaceable(World world, Block replaceID, int replaceMeta, int x, int y, int z) {
        if (FOUND_ORE_BLOCKS.contains(new Integer[]{Block.getIdFromBlock((Block)replaceID), replaceMeta})) {
            return false;
        }
        if (replaceID == Blocks.dirt) {
            return true;
        }
        if (replaceID == Blocks.grass) {
            return true;
        }
        if (replaceID == Blocks.gravel) {
            return true;
        }
        return replaceID != Blocks.air && replaceID.isReplaceableOreGen(world, x, y, z, Blocks.stone);
    }

    private static boolean isNetherReplaceable(World world, Block replaceID, int replaceMeta, int x, int y, int z) {
        if (FOUND_ORE_BLOCKS.contains(new Integer[]{Block.getIdFromBlock((Block)replaceID), replaceMeta})) {
            return false;
        }
        if (replaceID == Blocks.netherrack) {
            return true;
        }
        return replaceID != Blocks.air && replaceID.isReplaceableOreGen(world, x, y, z, Blocks.netherrack);
    }

    private static boolean findVein(World world, int x, int y, int z, Block oreID, int oreMeta, Map<ChunkCoordinates, Optional<TileEntity>> veinBlocks) {
        ChunkCoordinates here = new ChunkCoordinates(x, y, z);
        if (veinBlocks.containsKey(here)) {
            return false;
        }
        if (veinBlocks.size() >= 24) {
            return false;
        }
        if (world.getBlock(x, y, z) == oreID && world.getBlockMetadata(x, y, z) == oreMeta) {
            veinBlocks.put(here, Optional.ofNullable(world.getTileEntity(x, y, z)));
            ItemTFOreMagnet.findVein(world, x + 1, y, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x - 1, y, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y + 1, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y - 1, z, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y, z + 1, oreID, oreMeta, veinBlocks);
            ItemTFOreMagnet.findVein(world, x, y, z - 1, oreID, oreMeta, veinBlocks);
            return true;
        }
        return false;
    }

    public static boolean isOre(Block blockID, int meta) {
        if (blockID == Blocks.coal_ore) {
            return true;
        }
        if (blockID == Blocks.iron_ore) {
            return true;
        }
        if (blockID == Blocks.diamond_ore) {
            return true;
        }
        if (blockID == Blocks.emerald_ore) {
            return true;
        }
        if (blockID == Blocks.gold_ore) {
            return true;
        }
        if (blockID == Blocks.lapis_ore) {
            return true;
        }
        if (blockID == Blocks.redstone_ore) {
            return true;
        }
        if (blockID == Blocks.lit_redstone_ore) {
            return true;
        }
        if (blockID == Blocks.quartz_ore) {
            return true;
        }
        if (blockID == TFBlocks.root && meta == 1) {
            return true;
        }
        return blockID.getUnlocalizedName().toLowerCase().contains("ore");
    }
}

