/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFPeacockFan
extends ItemTF {
    protected ItemTFPeacockFan() {
        this.setCreativeTab(TFItems.creativeTab);
        this.maxStackSize = 1;
        this.setMaxDamage(1024);
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            if (!player.onGround) {
                player.addPotionEffect(new PotionEffect(Potion.jump.id, 45, 0));
            } else {
                int fanned = 0;
                fanned = this.doFan(world, player);
                if (fanned > 0) {
                    par1ItemStack.damageItem(fanned, (EntityLivingBase)player);
                }
            }
        } else {
            if (!player.onGround && !player.isPotionActive(Potion.jump.id)) {
                player.motionX *= 3.0;
                player.motionY = 1.5;
                player.motionZ *= 3.0;
                player.fallDistance = 0.0f;
            } else {
                AxisAlignedBB fanBox = this.getEffectAABB(world, player);
                Vec3 lookVec = player.getLookVec();
                for (int i = 0; i < 30; ++i) {
                    world.spawnParticle("cloud", fanBox.minX + (double)world.rand.nextFloat() * (fanBox.maxX - fanBox.minX), fanBox.minY + (double)world.rand.nextFloat() * (fanBox.maxY - fanBox.minY), fanBox.minZ + (double)world.rand.nextFloat() * (fanBox.maxZ - fanBox.minZ), lookVec.xCoord, lookVec.yCoord, lookVec.zCoord);
                }
            }
            world.playSound(player.posX + 0.5, player.posY + 0.5, player.posZ + 0.5, "random.breath", 1.0f + itemRand.nextFloat(), itemRand.nextFloat() * 0.7f + 0.3f, false);
        }
        player.setItemInUse(par1ItemStack, this.getMaxItemUseDuration(par1ItemStack));
        return par1ItemStack;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 20;
    }

    public boolean isFull3D() {
        return true;
    }

    private int doFan(World world, EntityPlayer player) {
        AxisAlignedBB fanBox = this.getEffectAABB(world, player);
        this.fanBlocksInAABB(world, player, fanBox);
        this.fanEntitiesInAABB(world, player, fanBox);
        return 1;
    }

    private void fanEntitiesInAABB(World world, EntityPlayer player, AxisAlignedBB fanBox) {
        Vec3 moveVec = player.getLookVec();
        List inBox = world.getEntitiesWithinAABB(Entity.class, fanBox);
        float force = 2.0f;
        for (Entity entity : inBox) {
            if (!entity.canBePushed() && !(entity instanceof EntityItem)) continue;
            entity.motionX = moveVec.xCoord * (double)force;
            entity.motionY = moveVec.yCoord * (double)force;
            entity.motionZ = moveVec.zCoord * (double)force;
        }
    }

    private AxisAlignedBB getEffectAABB(World world, EntityPlayer player) {
        double range = 3.0;
        double radius = 2.0;
        Vec3 srcVec = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 lookVec = player.getLookVec();
        Vec3 destVec = srcVec.addVector(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range);
        AxisAlignedBB crumbleBox = AxisAlignedBB.getBoundingBox((double)(destVec.xCoord - radius), (double)(destVec.yCoord - radius), (double)(destVec.zCoord - radius), (double)(destVec.xCoord + radius), (double)(destVec.yCoord + radius), (double)(destVec.zCoord + radius));
        return crumbleBox;
    }

    private int fanBlocksInAABB(World world, EntityPlayer player, AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        int fan = 0;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    fan += this.fanBlock(world, player, dx, dy, dz);
                }
            }
        }
        return fan;
    }

    private int fanBlock(World world, EntityPlayer player, int dx, int dy, int dz) {
        int cost = 0;
        Block currentID = world.getBlock(dx, dy, dz);
        if (currentID != Blocks.air) {
            int currentMeta = world.getBlockMetadata(dx, dy, dz);
            if (currentID instanceof BlockFlower && currentID.canHarvestBlock(player, currentMeta) && itemRand.nextInt(3) == 0) {
                currentID.harvestBlock(world, player, dx, dy, dz, currentMeta);
                world.setBlock(dx, dy, dz, Blocks.air, 0, 3);
                world.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
            }
        }
        return cost;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

