/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFHedgeSpider;
import twilightforest.entity.EntityTFHostileWolf;
import twilightforest.entity.EntityTFMinotaur;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.EntityTFSkeletonDruid;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.EntityTFWraith;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFPenguin;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;

public class ItemTFTransformPowder
extends ItemTF {
    HashMap<Class<? extends EntityLivingBase>, Class<? extends EntityLivingBase>> transformMap;

    protected ItemTFTransformPowder() {
        this.maxStackSize = 64;
        this.setCreativeTab(TFItems.creativeTab);
        this.transformMap = new HashMap();
        this.addTwoWayTransformation(EntityTFMinotaur.class, EntityPigZombie.class);
        this.addTwoWayTransformation(EntityTFDeer.class, EntityCow.class);
        this.addTwoWayTransformation(EntityTFBighorn.class, EntitySheep.class);
        this.addTwoWayTransformation(EntityTFBoar.class, EntityPig.class);
        this.addTwoWayTransformation(EntityTFRaven.class, EntityBat.class);
        this.addTwoWayTransformation(EntityTFHostileWolf.class, EntityWolf.class);
        this.addTwoWayTransformation(EntityTFPenguin.class, EntityChicken.class);
        this.addTwoWayTransformation(EntityTFHedgeSpider.class, EntitySpider.class);
        this.addTwoWayTransformation(EntityTFSwarmSpider.class, EntityCaveSpider.class);
        this.addTwoWayTransformation(EntityTFWraith.class, EntityBlaze.class);
        this.addTwoWayTransformation(EntityTFRedcap.class, EntityVillager.class);
        this.addTwoWayTransformation(EntityTFSkeletonDruid.class, EntityWitch.class);
    }

    public void addTwoWayTransformation(Class<? extends EntityLivingBase> class1, Class<? extends EntityLivingBase> class2) {
        this.transformMap.put(class1, class2);
        this.transformMap.put(class2, class1);
    }

    public boolean itemInteractionForEntity(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, EntityLivingBase target) {
        Class<? extends EntityLivingBase> transformClass = this.getMonsterTransform(target.getClass());
        if (transformClass != null) {
            if (target.worldObj.isRemote) {
                if (target instanceof EntityLiving) {
                    ((EntityLiving)target).spawnExplosionParticle();
                    ((EntityLiving)target).spawnExplosionParticle();
                }
                target.worldObj.playSound(target.posX + 0.5, target.posY + 0.5, target.posZ + 0.5, "mob.zombie.remedy", 1.0f + itemRand.nextFloat(), itemRand.nextFloat() * 0.7f + 0.3f, false);
            } else {
                EntityLivingBase newMonster = null;
                try {
                    newMonster = transformClass.getConstructor(World.class).newInstance(target.worldObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (newMonster == null) {
                    return false;
                }
                newMonster.setPositionAndRotation(target.posX, target.posY, target.posZ, target.rotationYaw, target.rotationPitch);
                target.worldObj.spawnEntityInWorld((Entity)newMonster);
                target.setDead();
            }
            --par1ItemStack.stackSize;
            return true;
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World world, EntityPlayer player) {
        if (world.isRemote) {
            AxisAlignedBB fanBox = this.getEffectAABB(world, player);
            for (int i = 0; i < 30; ++i) {
                world.spawnParticle("magicCrit", fanBox.minX + (double)world.rand.nextFloat() * (fanBox.maxX - fanBox.minX), fanBox.minY + (double)world.rand.nextFloat() * (fanBox.maxY - fanBox.minY), fanBox.minZ + (double)world.rand.nextFloat() * (fanBox.maxZ - fanBox.minZ), 0.0, 0.0, 0.0);
            }
        }
        return par1ItemStack;
    }

    private AxisAlignedBB getEffectAABB(World world, EntityPlayer player) {
        double range = 2.0;
        double radius = 1.0;
        Vec3 srcVec = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 lookVec = player.getLookVec();
        Vec3 destVec = srcVec.addVector(lookVec.xCoord * range, lookVec.yCoord * range, lookVec.zCoord * range);
        return AxisAlignedBB.getBoundingBox((double)(destVec.xCoord - radius), (double)(destVec.yCoord - radius), (double)(destVec.zCoord - radius), (double)(destVec.xCoord + radius), (double)(destVec.yCoord + radius), (double)(destVec.zCoord + radius));
    }

    public Class<? extends EntityLivingBase> getMonsterTransform(Class<? extends EntityLivingBase> originalMonster) {
        return this.transformMap.get(originalMonster);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("TwilightForest:" + this.getUnlocalizedName().substring(5));
    }
}

