/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFTreasure;
import twilightforest.structures.StructureTFDecorator;
import twilightforest.structures.StructureTFStrongholdStones;

public abstract class StructureTFComponent
extends StructureComponent {
    private static final StructureTFStrongholdStones strongholdStones = new StructureTFStrongholdStones();
    public StructureTFDecorator deco = null;
    public int spawnListIndex = 0;

    public StructureTFComponent() {
    }

    public StructureTFComponent(int i) {
        super(i);
    }

    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setInteger("si", this.spawnListIndex);
        par1NBTTagCompound.setString("deco", StructureTFDecorator.getDecoString(this.deco));
    }

    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        this.spawnListIndex = par1NBTTagCompound.getInteger("si");
        this.deco = StructureTFDecorator.getDecoFor(par1NBTTagCompound.getString("deco"));
    }

    public static StructureBoundingBox getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int dir) {
        switch (dir) {
            default: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case 1: {
                return new StructureBoundingBox(x - maxZ + minZ, y + minY, z + minX, x + minZ, y + maxY + minY, z + maxX + minX);
            }
            case 2: {
                return new StructureBoundingBox(x - maxX - minX, y + minY, z - maxZ - minZ, x - minX, y + maxY + minY, z - minZ);
            }
            case 3: 
        }
        return new StructureBoundingBox(x + minZ, y + minY, z - maxX, x + maxZ + minZ, y + maxY + minY, z + minX);
    }

    public static StructureBoundingBox getComponentToAddBoundingBox2(int x, int y, int z, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int dir) {
        switch (dir) {
            default: {
                return new StructureBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case 1: {
                return new StructureBoundingBox(x - maxZ - minZ, y + minY, z + minX, x - minZ, y + maxY + minY, z + maxX + minX);
            }
            case 2: {
                return new StructureBoundingBox(x - maxX - minX, y + minY, z - maxZ - minZ, x - minX, y + maxY + minY, z - minZ);
            }
            case 3: 
        }
        return new StructureBoundingBox(x + minZ, y + minY, z - maxX, x + maxZ + minZ, y + maxY + minY, z - minX);
    }

    protected TileEntityMobSpawner placeSpawnerAtCurrentPosition(World world, Random rand, int x, int y, int z, String monsterID, StructureBoundingBox sbb) {
        int dz;
        int dy;
        TileEntityMobSpawner tileEntitySpawner = null;
        int dx = this.getXWithOffset(x, z);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffset(x, z)) && world.getBlock(dx, dy, dz) != Blocks.mob_spawner) {
            world.setBlock(dx, dy, dz, Blocks.mob_spawner, 0, 2);
            tileEntitySpawner = (TileEntityMobSpawner)world.getTileEntity(dx, dy, dz);
            if (tileEntitySpawner != null) {
                tileEntitySpawner.func_145881_a().setEntityName(monsterID);
            }
        }
        return tileEntitySpawner;
    }

    protected TileEntityMobSpawner placeSpawnerRotated(World world, int x, int y, int z, int rotation, String monsterID, StructureBoundingBox sbb) {
        int dz;
        int dy;
        TileEntityMobSpawner tileEntitySpawner = null;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation)) && world.getBlock(dx, dy, dz) != Blocks.mob_spawner) {
            world.setBlock(dx, dy, dz, Blocks.mob_spawner, 0, 2);
            tileEntitySpawner = (TileEntityMobSpawner)world.getTileEntity(dx, dy, dz);
            if (tileEntitySpawner != null) {
                tileEntitySpawner.func_145881_a().setEntityName(monsterID);
            }
        }
        return tileEntitySpawner;
    }

    protected void placeTreasureAtCurrentPosition(World world, Random rand, int x, int y, int z, TFTreasure treasureType, StructureBoundingBox sbb) {
        this.placeTreasureAtCurrentPosition(world, rand, x, y, z, treasureType, false, sbb);
    }

    protected void placeTreasureAtCurrentPosition(World world, Random rand, int x, int y, int z, TFTreasure treasureType, boolean trapped, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffset(x, z);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffset(x, z)) && world.getBlock(dx, dy, dz) != Blocks.chest) {
            treasureType.generate(world, rand, dx, dy, dz, (Block)(trapped ? Blocks.trapped_chest : Blocks.chest));
        }
    }

    protected void placeTreasureRotated(World world, int x, int y, int z, int rotation, TFTreasure treasureType, StructureBoundingBox sbb) {
        this.placeTreasureRotated(world, x, y, z, rotation, treasureType, false, sbb);
    }

    protected void placeTreasureRotated(World world, int x, int y, int z, int rotation, TFTreasure treasureType, boolean trapped, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation)) && world.getBlock(dx, dy, dz) != Blocks.chest) {
            treasureType.generate(world, null, dx, dy, dz, (Block)(trapped ? Blocks.trapped_chest : Blocks.chest));
        }
    }

    protected void placeSignAtCurrentPosition(World world, int x, int y, int z, String string0, String string1, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffset(x, z);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffset(x, z)) && world.getBlock(dx, dy, dz) != Blocks.standing_sign) {
            world.setBlock(dx, dy, dz, Blocks.standing_sign, this.coordBaseMode * 2, 2);
            TileEntitySign teSign = (TileEntitySign)world.getTileEntity(dx, dy, dz);
            if (teSign != null) {
                teSign.signText[1] = string0;
                teSign.signText[2] = string1;
            }
        }
    }

    protected int[] offsetTowerCoords(int x, int y, int z, int towerSize, int direction) {
        int dx = this.getXWithOffset(x, z);
        int dy = this.getYWithOffset(y);
        int dz = this.getZWithOffset(x, z);
        switch (direction) {
            case 0: {
                return new int[]{dx + 1, dy - 1, dz - towerSize / 2};
            }
            case 1: {
                return new int[]{dx + towerSize / 2, dy - 1, dz + 1};
            }
            case 2: {
                return new int[]{dx - 1, dy - 1, dz + towerSize / 2};
            }
            case 3: {
                return new int[]{dx - towerSize / 2, dy - 1, dz - 1};
            }
        }
        return new int[]{x, y, z};
    }

    protected ChunkCoordinates offsetTowerCCoords(int x, int y, int z, int towerSize, int direction) {
        int dx = this.getXWithOffset(x, z);
        int dy = this.getYWithOffset(y);
        int dz = this.getZWithOffset(x, z);
        switch (direction) {
            case 0: {
                return new ChunkCoordinates(dx + 1, dy - 1, dz - towerSize / 2);
            }
            case 1: {
                return new ChunkCoordinates(dx + towerSize / 2, dy - 1, dz + 1);
            }
            case 2: {
                return new ChunkCoordinates(dx - 1, dy - 1, dz + towerSize / 2);
            }
            case 3: {
                return new ChunkCoordinates(dx - towerSize / 2, dy - 1, dz - 1);
            }
        }
        return new ChunkCoordinates(x, y, z);
    }

    public int[] getOffsetAsIfRotated(int[] src, int rotation) {
        int temp = this.getCoordBaseMode();
        int[] dest = new int[3];
        this.setCoordBaseMode(rotation);
        dest[0] = this.getXWithOffset(src[0], src[2]);
        dest[1] = this.getYWithOffset(src[1]);
        dest[2] = this.getZWithOffset(src[0], src[2]);
        this.setCoordBaseMode(temp);
        return dest;
    }

    protected int getXWithOffset(int x, int z) {
        switch (this.getCoordBaseMode()) {
            case 0: {
                return this.boundingBox.minX + x;
            }
            case 1: {
                return this.boundingBox.maxX - z;
            }
            case 2: {
                return this.boundingBox.maxX - x;
            }
            case 3: {
                return this.boundingBox.minX + z;
            }
        }
        return x;
    }

    protected int getYWithOffset(int par1) {
        return super.getYWithOffset(par1);
    }

    protected int getZWithOffset(int x, int z) {
        switch (this.getCoordBaseMode()) {
            case 0: {
                return this.boundingBox.minZ + z;
            }
            case 1: {
                return this.boundingBox.minZ + x;
            }
            case 2: {
                return this.boundingBox.maxZ - z;
            }
            case 3: {
                return this.boundingBox.maxZ - x;
            }
        }
        return z;
    }

    protected int getXWithOffsetAsIfRotated(int x, int z, int rotation) {
        if (this.coordBaseMode < 0) {
            return x;
        }
        switch ((this.coordBaseMode + rotation) % 4) {
            case 0: {
                return this.boundingBox.minX + x;
            }
            case 1: {
                return this.boundingBox.maxX - z;
            }
            case 2: {
                return this.boundingBox.maxX - x;
            }
            case 3: {
                return this.boundingBox.minX + z;
            }
        }
        return x;
    }

    protected int getZWithOffsetAsIfRotated(int x, int z, int rotation) {
        if (this.coordBaseMode < 0) {
            return x;
        }
        switch ((this.coordBaseMode + rotation) % 4) {
            case 0: {
                return this.boundingBox.minZ + z;
            }
            case 1: {
                return this.boundingBox.minZ + x;
            }
            case 2: {
                return this.boundingBox.maxZ - z;
            }
            case 3: {
                return this.boundingBox.maxZ - x;
            }
        }
        return z;
    }

    public int getCoordBaseMode() {
        return this.coordBaseMode;
    }

    public void setCoordBaseMode(int coordBaseMode) {
        this.coordBaseMode = coordBaseMode;
    }

    protected Block getBlockAtCurrentPosition(World world, int x, int y, int z, StructureBoundingBox sbb) {
        return super.getBlockAtCurrentPosition(world, x, y, z, sbb);
    }

    protected void placeBlockAtCurrentPosition(World world, Block block, int par3, int par4, int par5, int par6, StructureBoundingBox sbb) {
        super.placeBlockAtCurrentPosition(world, block, par3, par4, par5, par6, sbb);
    }

    protected void placeBlockRotated(World world, Block blockID, int meta, int x, int y, int z, int rotation, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation))) {
            world.setBlock(dx, dy, dz, blockID, meta, 2);
        }
    }

    protected Block getBlockIDRotated(World world, int x, int y, int z, int rotation, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation))) {
            return world.getBlock(dx, dy, dz);
        }
        return Blocks.air;
    }

    protected void fillBlocksRotated(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block blockID, int meta, int rotation) {
        for (int dx = minY; dx <= maxY; ++dx) {
            for (int dy = minX; dy <= maxX; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    this.placeBlockRotated(world, blockID, meta, dy, dx, dz, rotation, sbb);
                }
            }
        }
    }

    protected void randomlyFillBlocksRotated(World world, StructureBoundingBox sbb, Random rand, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block blockID, int meta, Block blockID2, int meta2, int rotation) {
        for (int dx = minY; dx <= maxY; ++dx) {
            for (int dy = minX; dy <= maxX; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    if (rand.nextFloat() < chance) {
                        this.placeBlockRotated(world, blockID, meta, dy, dx, dz, rotation, sbb);
                        continue;
                    }
                    this.placeBlockRotated(world, blockID2, meta2, dy, dx, dz, rotation, sbb);
                }
            }
        }
    }

    public void fillToGroundRotated(World world, Block stonebrick, int meta, int x, int y, int z, int rotation, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.getXWithOffsetAsIfRotated(x, z, rotation);
        if (sbb.isVecInside(dx, dy = this.getYWithOffset(y), dz = this.getZWithOffsetAsIfRotated(x, z, rotation))) {
            while ((world.isAirBlock(dx, dy, dz) || world.getBlock(dx, dy, dz).getMaterial().isLiquid()) && dy > 1) {
                world.setBlock(dx, dy, dz, stonebrick, meta, 2);
                --dy;
            }
        }
    }

    protected void fillAirRotated(World world, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int rotation) {
        this.fillBlocksRotated(world, sbb, minX, minY, minZ, maxX, maxY, maxZ, Blocks.air, 0, rotation);
    }

    public static StructureComponent.BlockSelector getStrongholdStones() {
        return strongholdStones;
    }

    protected int getStairMeta(int dir) {
        switch ((this.getCoordBaseMode() + dir) % 4) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    protected int getLadderMeta(int ladderDir) {
        switch ((this.getCoordBaseMode() + ladderDir) % 4) {
            case 0: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    protected int getLadderMeta(int ladderDir, int rotation) {
        return this.getLadderMeta(ladderDir + rotation);
    }

    public void nullifySkyLightForBoundingBox(World world) {
        this.nullifySkyLight(world, this.boundingBox.minX - 1, this.boundingBox.minY - 1, this.boundingBox.minZ - 1, this.boundingBox.maxX + 1, this.boundingBox.maxY + 1, this.boundingBox.maxZ + 1);
    }

    public void nullifySkyLightAtCurrentPosition(World world, int sx, int sy, int sz, int dx, int dy, int dz) {
        this.nullifySkyLight(world, this.getXWithOffset(sx, sz), this.getYWithOffset(sy), this.getZWithOffset(sx, sz), this.getXWithOffset(dx, dz), this.getYWithOffset(dy), this.getZWithOffset(dx, dz));
    }

    public void nullifySkyLight(World world, int sx, int sy, int sz, int dx, int dy, int dz) {
        for (int x = sx; x <= dx; ++x) {
            for (int z = sz; z <= dz; ++z) {
                for (int y = sy; y <= dy; ++y) {
                    world.setLightValue(EnumSkyBlock.Sky, x, y, z, 0);
                }
            }
        }
    }

    protected int getAverageGroundLevel(World world, StructureBoundingBox sbb) {
        int totalHeight = 0;
        int heightCount = 0;
        for (int bz = this.boundingBox.minZ; bz <= this.boundingBox.maxZ; ++bz) {
            for (int by = this.boundingBox.minX; by <= this.boundingBox.maxX; ++by) {
                if (!sbb.isVecInside(by, 64, bz)) continue;
                totalHeight += Math.max(world.getTopSolidOrLiquidBlock(by, bz), world.provider.getAverageGroundLevel());
                ++heightCount;
            }
        }
        if (heightCount == 0) {
            return -1;
        }
        return totalHeight / heightCount;
    }

    protected int getSampledDirtLevel(World world, StructureBoundingBox sbb) {
        int dirtLevel = 256;
        for (int y = 90; y > 0; --y) {
            int cz;
            int cx = sbb.getCenterX();
            Material material = world.getBlock(cx, y, cz = sbb.getCenterZ()).getMaterial();
            if (material != Material.ground && material != Material.rock && material != Material.grass) continue;
            dirtLevel = y;
            break;
        }
        return dirtLevel;
    }

    protected void randomlyPlaceBlock(World world, StructureBoundingBox sbb, Random rand, float chance, int x, int y, int z, Block blockPlaced, int meta) {
        this.func_151552_a(world, sbb, rand, chance, x, y, z, blockPlaced, meta);
    }

    public boolean isComponentProtected() {
        return true;
    }

    public static StructureComponent findIntersectingExcluding(List list, StructureBoundingBox toCheck, StructureComponent exclude) {
        StructureComponent structurecomponent;
        Iterator iterator = list.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((structurecomponent = (StructureComponent)iterator.next()) == exclude || structurecomponent.getBoundingBox() == null || !structurecomponent.getBoundingBox().intersectsWith(toCheck));
        return structurecomponent;
    }
}

