/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleFoundation13;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleFoundation13Thorns;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleMazeTower13;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleWreckedTower;
import twilightforest.structures.finalcastle.DestroyArea;

public class ComponentTFFinalCastleDamagedTower
extends ComponentTFFinalCastleMazeTower13 {
    public ComponentTFFinalCastleDamagedTower() {
    }

    public ComponentTFFinalCastleDamagedTower(Random rand, int i, int x, int y, int z, int direction) {
        super(rand, i, x, y, z, 2, direction);
    }

    @Override
    public void buildComponent(StructureComponent parent, List list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        ComponentTFFinalCastleFoundation13 foundation = new ComponentTFFinalCastleFoundation13(rand, 0, this);
        list.add(foundation);
        foundation.buildComponent(this, list, rand);
        ComponentTFFinalCastleFoundation13Thorns thorns = new ComponentTFFinalCastleFoundation13Thorns(rand, 0, this);
        list.add(thorns);
        thorns.buildComponent(this, list, rand);
        this.buildNonCriticalTowers(parent, list, rand);
    }

    @Override
    protected ComponentTFFinalCastleMazeTower13 makeNewDamagedTower(Random rand, int direction, ChunkCoordinates tc) {
        return new ComponentTFFinalCastleWreckedTower(rand, this.getComponentType() + 1, tc.posX, tc.posY, tc.posZ, direction);
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        super.addComponentParts(world, rand, sbb);
        Random decoRNG = new Random(world.getSeed() + (long)(this.boundingBox.minX * 321534781) ^ (long)(this.boundingBox.minZ * 756839));
        this.destroyTower(world, decoRNG, sbb);
        return true;
    }

    public void destroyTower(World world, Random rand, StructureBoundingBox sbb) {
        ArrayList<DestroyArea> areas = this.makeInitialDestroyList(rand);
        boolean hitDeadRock = false;
        for (int y = this.boundingBox.maxY; !hitDeadRock && y > 64; --y) {
            for (int x = this.boundingBox.minX - 2; x <= this.boundingBox.maxX + 2; ++x) {
                for (int z = this.boundingBox.minZ - 2; z <= this.boundingBox.maxZ + 2; ++z) {
                    if (!sbb.isVecInside(x, y, z)) continue;
                    if (world.getBlock(x, y, z) == TFBlocks.deadrock) {
                        hitDeadRock = true;
                    }
                    this.determineBlockDestroyed(world, areas, y, x, z);
                }
            }
            DestroyArea removeArea = null;
            for (DestroyArea dArea : areas) {
                if (dArea != null && !dArea.isEntirelyAbove(y)) continue;
                removeArea = dArea;
            }
            if (removeArea == null) continue;
            areas.remove(removeArea);
            areas.add(DestroyArea.createNonIntersecting(this.getBoundingBox(), rand, y, areas));
        }
    }

    protected ArrayList<DestroyArea> makeInitialDestroyList(Random rand) {
        ArrayList<DestroyArea> areas = new ArrayList<DestroyArea>(2);
        areas.add(DestroyArea.createNonIntersecting(this.getBoundingBox(), rand, this.getBoundingBox().maxY - 1, areas));
        areas.add(DestroyArea.createNonIntersecting(this.getBoundingBox(), rand, this.getBoundingBox().maxY - 1, areas));
        areas.add(DestroyArea.createNonIntersecting(this.getBoundingBox(), rand, this.getBoundingBox().maxY - 1, areas));
        return areas;
    }

    protected void determineBlockDestroyed(World world, ArrayList<DestroyArea> areas, int y, int x, int z) {
        for (DestroyArea dArea : areas) {
            if (dArea == null || !dArea.isVecInside(x, y, z)) continue;
            world.setBlockToAir(x, y, z);
        }
    }
}

