/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleFoundation13;

public class ComponentTFFinalCastleFoundation13Thorns
extends ComponentTFFinalCastleFoundation13 {
    public ComponentTFFinalCastleFoundation13Thorns() {
    }

    public ComponentTFFinalCastleFoundation13Thorns(Random rand, int i, StructureTFComponent sideTower) {
        super(rand, i, sideTower);
        this.boundingBox = new StructureBoundingBox(sideTower.getBoundingBox().minX - 5, sideTower.getBoundingBox().maxY - 1, sideTower.getBoundingBox().minZ - 5, sideTower.getBoundingBox().maxX + 5, sideTower.getBoundingBox().maxY, sideTower.getBoundingBox().maxZ + 5);
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        Random decoRNG = new Random(world.getSeed() + (long)(this.boundingBox.minX * 321534781) ^ (long)(this.boundingBox.minZ * 756839));
        for (int i = 0; i < 4; ++i) {
            this.makeThornVine(world, decoRNG, i, sbb);
        }
        return true;
    }

    private void makeThornVine(World world, Random decoRNG, int rotation, StructureBoundingBox sbb) {
        int x = 3 + decoRNG.nextInt(13);
        int z = 3 + decoRNG.nextInt(13);
        int y = this.boundingBox.getYSize() + 5;
        int twist = decoRNG.nextInt(4);
        int twistMod = 3 + decoRNG.nextInt(3);
        while (this.getBlockIDRotated(world, x, y, z, rotation, sbb) != TFBlocks.deadrock && this.getYWithOffset(y) > 60) {
            this.placeBlockRotated(world, TFBlocks.thorns, 0, x, y, z, rotation, sbb);
            switch (twist) {
                case 0: {
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x + 1, y, z, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x, y, z + 1, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x + 1, y, z + 1, rotation, sbb);
                    break;
                }
                case 1: {
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x + 1, y, z, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x, y, z - 1, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x + 1, y, z - 1, rotation, sbb);
                    break;
                }
                case 2: {
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x - 1, y, z, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x, y, z - 1, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x - 1, y, z - 1, rotation, sbb);
                    break;
                }
                case 3: {
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x - 1, y, z, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x, y, z + 1, rotation, sbb);
                    this.placeBlockRotated(world, TFBlocks.thorns, 0, x - 1, y, z + 1, rotation, sbb);
                }
            }
            if (Math.abs(y % twistMod) == 1) {
                this.makeThornBranch(world, x, y, z, rotation, sbb);
            }
            if (y % twistMod == 0) {
                ++twist;
                twist %= 4;
            }
            --y;
        }
    }

    private void makeThornBranch(World world, int x, int y, int z, int rotation, StructureBoundingBox sbb) {
        Random rand = new Random(world.getSeed() + (long)(x * 321534781) ^ (long)(y * 756839 + z));
        int dir = rand.nextInt(4);
        int dx = 0;
        int dz = 0;
        switch (dir) {
            case 0: {
                dx = 1;
                break;
            }
            case 1: {
                dz = 1;
                break;
            }
            case 2: {
                dx = -1;
                break;
            }
            case 3: {
                dz = -1;
            }
        }
        int dist = 2 + rand.nextInt(3);
        int destX = x + dist * dx;
        int destZ = z + dist * dz;
        if (destX > 0 && destX < this.boundingBox.getXSize() && destZ > 0 && destZ < this.boundingBox.getZSize()) {
            for (int i = 0; i < dist; ++i) {
                int branchMeta;
                int n = branchMeta = (dir + rotation + this.coordBaseMode) % 2 == 0 ? 5 : 9;
                if (i > 0) {
                    this.placeBlockRotated(world, TFBlocks.thorns, branchMeta, x + dx * i, y, z + dz * i, rotation, sbb);
                }
                this.placeBlockRotated(world, TFBlocks.thorns, 1, destX, y + i, destZ, rotation, sbb);
                if (i <= dist / 2) continue;
                this.placeBlockRotated(world, TFBlocks.thorns, branchMeta, x + dx * i, y + dist - 1, z + dz * i, rotation, sbb);
            }
        }
    }
}

