/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.List;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeLeafDungeon;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeMedBranch;
import twilightforest.world.TFGenerator;

public class ComponentTFHollowTreeLargeBranch
extends ComponentTFHollowTreeMedBranch {
    private static final int LEAF_DUNGEON_CHANCE = 8;
    public boolean hasLeafDungeon = false;

    public ComponentTFHollowTreeLargeBranch() {
    }

    protected ComponentTFHollowTreeLargeBranch(int i, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        super(i, sx, sy, sz, length, angle, tilt, leafy);
    }

    @Override
    public void buildComponent(StructureComponent structurecomponent, List list, Random rand) {
        int index = this.getComponentType();
        int numMedBranches = rand.nextInt((int)(this.length / 6.0)) + (int)(this.length / 8.0);
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = rand.nextDouble() * 0.3 + 0.3;
            double angleVar = rand.nextDouble() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            ChunkCoordinates bsrc = TFGenerator.translateCoords(this.src.posX, this.src.posY, this.src.posZ, this.length * outVar, this.angle, this.tilt);
            this.makeMedBranch(list, rand, index + 2 + i, bsrc.posX, bsrc.posY, bsrc.posZ, this.length * 0.6, this.angle + angleVar, this.tilt, this.leafy);
        }
        boolean bl = this.hasLeafDungeon = rand.nextInt(8) == 0;
        if (this.hasLeafDungeon) {
            this.makeLeafDungeon(list, rand, index + 1, this.dest.posX, this.dest.posY, this.dest.posZ);
        }
    }

    public void makeLeafDungeon(List list, Random rand, int index, int x, int y, int z) {
        ComponentTFHollowTreeLeafDungeon dungeon = new ComponentTFHollowTreeLeafDungeon(index, x, y, z, 4);
        list.add(dungeon);
        dungeon.buildComponent(this, list, rand);
    }

    public void makeMedBranch(List list, Random rand, int index, int x, int y, int z, double branchLength, double branchRotation, double branchAngle, boolean leafy) {
        ComponentTFHollowTreeMedBranch branch = new ComponentTFHollowTreeMedBranch(index, x, y, z, branchLength, branchRotation, branchAngle, leafy);
        list.add(branch);
        branch.buildComponent(this, list, rand);
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        ChunkCoordinates rsrc = new ChunkCoordinates(this.src.posX - this.boundingBox.minX, this.src.posY - this.boundingBox.minY, this.src.posZ - this.boundingBox.minZ);
        ChunkCoordinates rdest = new ChunkCoordinates(this.dest.posX - this.boundingBox.minX, this.dest.posY - this.boundingBox.minY, this.dest.posZ - this.boundingBox.minZ);
        this.drawBresehnam(world, sbb, rsrc.posX, rsrc.posY, rsrc.posZ, rdest.posX, rdest.posY, rdest.posZ, TFBlocks.log, 12);
        int reinforcements = 4;
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            this.drawBresehnam(world, sbb, rsrc.posX + vx, rsrc.posY + vy, rsrc.posZ + vz, rdest.posX, rdest.posY, rdest.posZ, TFBlocks.log, 12);
        }
        Random decoRNG = new Random(world.getSeed() + (long)(this.boundingBox.minX * 321534781) ^ (long)(this.boundingBox.minZ * 756839));
        int numSmallBranches = decoRNG.nextInt(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = decoRNG.nextFloat() * 0.25f + 0.25f;
            double angleVar = decoRNG.nextFloat() * 0.25f * ((i & 1) == 0 ? 1.0f : -1.0f);
            ChunkCoordinates bsrc = TFGenerator.translateCoords(rsrc.posX, rsrc.posY, rsrc.posZ, this.length * outVar, this.angle, this.tilt);
            this.drawSmallBranch(world, sbb, bsrc.posX, bsrc.posY, bsrc.posZ, Math.max(this.length * (double)0.3f, 2.0), this.angle + angleVar, this.tilt, this.leafy);
        }
        if (this.leafy && !this.hasLeafDungeon) {
            this.makeLeafBlob(world, sbb, rdest.posX, rdest.posY, rdest.posZ, 3);
        }
        return true;
    }
}

