/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFTreasure;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFCreatures;
import twilightforest.structures.StructureTFComponent;

public class ComponentTFHollowTreeLeafDungeon
extends StructureTFComponent {
    int radius;

    public ComponentTFHollowTreeLeafDungeon() {
    }

    protected ComponentTFHollowTreeLeafDungeon(int index, int x, int y, int z, int radius) {
        super(index);
        this.setCoordBaseMode(0);
        this.boundingBox = new StructureBoundingBox(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        this.radius = radius;
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("leafRadius", this.radius);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.radius = par1NBTTagCompound.getInteger("leafRadius");
    }

    public void buildComponent(StructureComponent structurecomponent, List list, Random rand) {
        this.setCoordBaseMode(rand.nextInt(4));
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        this.drawBlockBlob(world, sbb, this.radius, this.radius, this.radius, 4, TFBlocks.leaves, 0, true);
        this.drawBlockBlob(world, sbb, this.radius, this.radius, this.radius, 3, TFBlocks.log, 12, false);
        this.drawBlockBlob(world, sbb, this.radius, this.radius, this.radius, 2, Blocks.air, 0, false);
        this.placeTreasureAtCurrentPosition(world, rand, this.radius + 2, this.radius - 1, this.radius, TFTreasure.tree_cache, sbb);
        this.placeSpawnerAtCurrentPosition(world, rand, this.radius, this.radius, this.radius, TFCreatures.getSpawnerNameFor("Swarm Spider"), sbb);
        return true;
    }

    private void drawBlockBlob(World world, StructureBoundingBox sbb, int sx, int sy, int sz, int blobRadius, Block blockID, int metadata, boolean isLeaves) {
        for (int dx = 0; dx <= blobRadius; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= blobRadius; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= blobRadius; dz = (int)((byte)(dz + 1))) {
                    byte dist = 0;
                    dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > blobRadius) continue;
                    if (isLeaves) {
                        this.placeLeafBlock(world, blockID, metadata, sx + dx, sy + dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockID, metadata, sx + dx, sy + dy, sz - dz, sbb);
                        this.placeLeafBlock(world, blockID, metadata, sx - dx, sy + dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockID, metadata, sx - dx, sy + dy, sz - dz, sbb);
                        this.placeLeafBlock(world, blockID, metadata, sx + dx, sy - dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockID, metadata, sx + dx, sy - dy, sz - dz, sbb);
                        this.placeLeafBlock(world, blockID, metadata, sx - dx, sy - dy, sz + dz, sbb);
                        this.placeLeafBlock(world, blockID, metadata, sx - dx, sy - dy, sz - dz, sbb);
                        continue;
                    }
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx + dx, sy + dy, sz + dz, sbb);
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx + dx, sy + dy, sz - dz, sbb);
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx - dx, sy + dy, sz + dz, sbb);
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx - dx, sy + dy, sz - dz, sbb);
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx + dx, sy - dy, sz + dz, sbb);
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx + dx, sy - dy, sz - dz, sbb);
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx - dx, sy - dy, sz + dz, sbb);
                    this.placeBlockAtCurrentPosition(world, blockID, metadata, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }

    protected void placeLeafBlock(World world, Block blockID, int meta, int x, int y, int z, StructureBoundingBox sbb) {
        Block whatsThere;
        int offZ;
        int offY;
        int offX = this.getXWithOffset(x, z);
        if (sbb.isVecInside(offX, offY = this.getYWithOffset(y), offZ = this.getZWithOffset(x, z)) && ((whatsThere = world.getBlock(offX, offY, offZ)) == null || whatsThere.canBeReplacedByLeaves((IBlockAccess)world, offX, offY, offZ))) {
            world.setBlock(offX, offY, offZ, blockID, meta, 2);
        }
    }
}

