/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeSmallBranch;
import twilightforest.world.TFGenerator;

public class ComponentTFHollowTreeMedBranch
extends StructureTFComponent {
    ChunkCoordinates src;
    ChunkCoordinates dest;
    double length;
    double angle;
    double tilt;
    boolean leafy;

    public ComponentTFHollowTreeMedBranch() {
    }

    protected ComponentTFHollowTreeMedBranch(int i, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        super(i);
        this.src = new ChunkCoordinates(sx, sy, sz);
        this.dest = TFGenerator.translateCoords(this.src.posX, this.src.posY, this.src.posZ, length, angle, tilt);
        this.length = length;
        this.angle = angle;
        this.tilt = tilt;
        this.leafy = leafy;
        this.setCoordBaseMode(0);
        this.boundingBox = new StructureBoundingBox(Math.min(this.src.posX, this.dest.posX), Math.min(this.src.posY, this.dest.posY), Math.min(this.src.posZ, this.dest.posZ), Math.max(this.src.posX, this.dest.posX), Math.max(this.src.posY, this.dest.posY), Math.max(this.src.posZ, this.dest.posZ));
        this.boundingBox.expandTo(this.makeExpandedBB(0.5, length, angle, tilt));
        this.boundingBox.expandTo(this.makeExpandedBB(0.1f, length, 0.225, tilt));
        this.boundingBox.expandTo(this.makeExpandedBB(0.1f, length, -0.225, tilt));
    }

    private StructureBoundingBox makeExpandedBB(double outVar, double branchLength, double branchAngle, double branchTilt) {
        ChunkCoordinates branchSrc = TFGenerator.translateCoords(this.src.posX, this.src.posY, this.src.posZ, this.length * outVar, this.angle, this.tilt);
        ChunkCoordinates branchDest = TFGenerator.translateCoords(branchSrc.posX, branchSrc.posY, branchSrc.posZ, branchLength, branchAngle, branchTilt);
        return new StructureBoundingBox(Math.min(branchSrc.posX, branchDest.posX), Math.min(branchSrc.posY, branchDest.posY), Math.min(branchSrc.posZ, branchDest.posZ), Math.max(branchSrc.posX, branchDest.posX), Math.max(branchSrc.posY, branchDest.posY), Math.max(branchSrc.posZ, branchDest.posZ));
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("srcPosX", this.src.posX);
        par1NBTTagCompound.setInteger("srcPosY", this.src.posY);
        par1NBTTagCompound.setInteger("srcPosZ", this.src.posZ);
        par1NBTTagCompound.setInteger("destPosX", this.dest.posX);
        par1NBTTagCompound.setInteger("destPosY", this.dest.posY);
        par1NBTTagCompound.setInteger("destPosZ", this.dest.posZ);
        par1NBTTagCompound.setDouble("branchLength", this.length);
        par1NBTTagCompound.setDouble("branchAngle", this.angle);
        par1NBTTagCompound.setDouble("branchTilt", this.tilt);
        par1NBTTagCompound.setBoolean("branchLeafy", this.leafy);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.src = new ChunkCoordinates(par1NBTTagCompound.getInteger("srcPosX"), par1NBTTagCompound.getInteger("srcPosY"), par1NBTTagCompound.getInteger("srcPosZ"));
        this.dest = new ChunkCoordinates(par1NBTTagCompound.getInteger("destPosX"), par1NBTTagCompound.getInteger("destPosY"), par1NBTTagCompound.getInteger("destPosZ"));
        this.length = par1NBTTagCompound.getDouble("branchLength");
        this.angle = par1NBTTagCompound.getDouble("branchAngle");
        this.tilt = par1NBTTagCompound.getDouble("branchTilt");
        this.leafy = par1NBTTagCompound.getBoolean("branchLeafy");
    }

    public void buildComponent(StructureComponent structurecomponent, List list, Random rand) {
        int index = this.getComponentType();
    }

    public void makeSmallBranch(List list, Random rand, int index, int x, int y, int z, double branchLength, double branchRotation, double branchAngle, boolean leafy) {
        ComponentTFHollowTreeSmallBranch branch = new ComponentTFHollowTreeSmallBranch(index, x, y, z, branchLength, branchRotation, branchAngle, leafy);
        list.add(branch);
        branch.buildComponent(this, list, rand);
    }

    public boolean addComponentParts(World world, Random random, StructureBoundingBox sbb) {
        double slength;
        ChunkCoordinates rSrc = new ChunkCoordinates(this.src.posX - this.boundingBox.minX, this.src.posY - this.boundingBox.minY, this.src.posZ - this.boundingBox.minZ);
        ChunkCoordinates rDest = new ChunkCoordinates(this.dest.posX - this.boundingBox.minX, this.dest.posY - this.boundingBox.minY, this.dest.posZ - this.boundingBox.minZ);
        this.drawBresehnam(world, sbb, rSrc.posX, rSrc.posY, rSrc.posZ, rDest.posX, rDest.posY, rDest.posZ, TFBlocks.log, 12);
        this.drawBresehnam(world, sbb, rSrc.posX, rSrc.posY + 1, rSrc.posZ, rDest.posX, rDest.posY, rDest.posZ, TFBlocks.log, 12);
        Random decoRNG = new Random(world.getSeed() + (long)(this.boundingBox.minX * 321534781) ^ (long)(this.boundingBox.minZ * 756839));
        int numShoots = Math.min(decoRNG.nextInt(3) + 1, (int)(this.length / 5.0));
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i < numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = decoRNG.nextDouble() * 0.8 + 0.2;
            double tiltVar = decoRNG.nextDouble() * 0.75 + 0.15;
            ChunkCoordinates bSrc = TFGenerator.translateCoords(rSrc.posX, rSrc.posY, rSrc.posZ, this.length * outVar, this.angle, this.tilt);
            slength = this.length * 0.4;
            this.drawSmallBranch(world, sbb, bSrc.posX, bSrc.posY, bSrc.posZ, Math.max(this.length * (double)0.3f, 2.0), this.angle + angleVar, this.tilt, this.leafy);
        }
        if (this.leafy) {
            int numLeafBalls = Math.min(decoRNG.nextInt(3) + 1, (int)(this.length / 5.0));
            for (int i = 0; i < numLeafBalls; ++i) {
                slength = (double)(decoRNG.nextFloat() * 0.6f + 0.2f) * this.length;
                ChunkCoordinates bdst = TFGenerator.translateCoords(rSrc.posX, rSrc.posY, rSrc.posZ, slength, this.angle, this.tilt);
                this.makeLeafBlob(world, sbb, bdst.posX, bdst.posY, bdst.posZ, decoRNG.nextBoolean() ? 2 : 3);
            }
            this.makeLeafBlob(world, sbb, rDest.posX, rDest.posY, rDest.posZ, 3);
        }
        return true;
    }

    protected void drawBresehnam(World world, StructureBoundingBox sbb, int x1, int y1, int z1, int x2, int y2, int z2, Block blockValue, int metaValue) {
        ChunkCoordinates[] lineCoords;
        for (ChunkCoordinates coords : lineCoords = TFGenerator.getBresehnamArrayCoords(x1, y1, z1, x2, y2, z2)) {
            this.placeBlockAtCurrentPosition(world, blockValue, metaValue, coords.posX, coords.posY, coords.posZ, sbb);
        }
    }

    protected void makeLeafBlob(World world, StructureBoundingBox sbb, int sx, int sy, int sz, int radius) {
        for (int dx = 0; dx <= radius; ++dx) {
            for (int dy = 0; dy <= radius; ++dy) {
                for (int dz = 0; dz <= radius; ++dz) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? (int)((float)dx + ((float)Math.max(dy, dz) * 0.5f + (float)Math.min(dy, dz) * 0.25f)) : (dy >= dx && dy >= dz ? (int)((float)dy + ((float)Math.max(dx, dz) * 0.5f + (float)Math.min(dx, dz) * 0.25f)) : (int)((float)dz + ((float)Math.max(dx, dy) * 0.5f + (float)Math.min(dx, dy) * 0.25f)));
                    if (dist > radius) continue;
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx + dx, sy + dy, sz + dz, sbb);
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx + dx, sy + dy, sz - dz, sbb);
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx - dx, sy + dy, sz + dz, sbb);
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx - dx, sy + dy, sz - dz, sbb);
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx + dx, sy - dy, sz + dz, sbb);
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx + dx, sy - dy, sz - dz, sbb);
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx - dx, sy - dy, sz + dz, sbb);
                    this.placeLeafBlock(world, TFBlocks.leaves, 0, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }

    protected void placeLeafBlock(World world, Block blockID, int meta, int x, int y, int z, StructureBoundingBox sbb) {
        Block whatsThere;
        int offZ;
        int offY;
        int offX = this.getXWithOffset(x, z);
        if (sbb.isVecInside(offX, offY = this.getYWithOffset(y), offZ = this.getZWithOffset(x, z)) && ((whatsThere = world.getBlock(offX, offY, offZ)) == null || whatsThere.canBeReplacedByLeaves((IBlockAccess)world, offX, offY, offZ))) {
            world.setBlock(offX, offY, offZ, blockID, meta, 2);
        }
    }

    protected void drawSmallBranch(World world, StructureBoundingBox sbb, int sx, int sy, int sz, double branchLength, double branchAngle, double branchTilt, boolean leafy) {
        ChunkCoordinates branchDest = TFGenerator.translateCoords(sx, sy, sz, branchLength, branchAngle, branchTilt);
        this.drawBresehnam(world, sbb, sx, sy, sz, branchDest.posX, branchDest.posY, branchDest.posZ, TFBlocks.log, 12);
        this.makeLeafBlob(world, sbb, branchDest.posX, branchDest.posY, branchDest.posZ, 2);
    }
}

