/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.hollowtree;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.block.TFBlocks;
import twilightforest.structures.hollowtree.ComponentTFHollowTreeMedBranch;
import twilightforest.world.TFGenerator;

public class ComponentTFHollowTreeRoot
extends ComponentTFHollowTreeMedBranch {
    private int groundLevel = -1;

    public ComponentTFHollowTreeRoot() {
    }

    public ComponentTFHollowTreeRoot(int i, int sx, int sy, int sz, double length, double angle, double tilt, boolean leafy) {
        super(i, sx, sy, sz, length, angle, tilt, leafy);
        this.boundingBox = new StructureBoundingBox(Math.min(this.src.posX, this.dest.posX), Math.min(this.src.posY, this.dest.posY), Math.min(this.src.posZ, this.dest.posZ), Math.max(this.src.posX, this.dest.posX), Math.max(this.src.posY, this.dest.posY), Math.max(this.src.posZ, this.dest.posZ));
    }

    @Override
    public boolean addComponentParts(World world, Random random, StructureBoundingBox sbb) {
        if (this.groundLevel < 0) {
            int rootHeight = this.boundingBox.maxY - this.boundingBox.minY;
            this.groundLevel = this.getSampledDirtLevel(world, sbb);
            if (this.groundLevel < 0) {
                return true;
            }
            this.src.posY = this.groundLevel + 5;
        }
        ChunkCoordinates rSrc = new ChunkCoordinates(this.src.posX - this.boundingBox.minX, this.src.posY - this.boundingBox.minY, this.src.posZ - this.boundingBox.minZ);
        ChunkCoordinates rDest = new ChunkCoordinates(this.dest.posX - this.boundingBox.minX, this.dest.posY - this.boundingBox.minY, this.dest.posZ - this.boundingBox.minZ);
        this.drawRootLine(world, sbb, rSrc.posX, rSrc.posY, rSrc.posZ, rDest.posX, rDest.posY, rDest.posZ, TFBlocks.root, 0);
        this.drawRootLine(world, sbb, rSrc.posX, rSrc.posY - 1, rSrc.posZ, rDest.posX, rDest.posY - 1, rDest.posZ, TFBlocks.root, 0);
        return true;
    }

    protected void drawRootLine(World world, StructureBoundingBox sbb, int x1, int y1, int z1, int x2, int y2, int z2, Block blockValue, int metaValue) {
        ChunkCoordinates[] lineCoords;
        for (ChunkCoordinates coords : lineCoords = TFGenerator.getBresehnamArrayCoords(x1, y1, z1, x2, y2, z2)) {
            Block block = this.getBlockAtCurrentPosition(world, coords.posX, coords.posY, coords.posZ, sbb);
            if (!block.isNormalCube((IBlockAccess)world, coords.posX, coords.posY, coords.posZ) || block != null && block.getMaterial() == Material.grass) {
                this.placeBlockAtCurrentPosition(world, TFBlocks.log, 12, coords.posX, coords.posY, coords.posZ, sbb);
                continue;
            }
            if (block != null && block.getMaterial() == Material.wood) continue;
            this.placeBlockAtCurrentPosition(world, blockValue, metaValue, coords.posX, coords.posY, coords.posZ, sbb);
        }
    }
}

