/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.lichtower;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.structures.lichtower.ComponentTFTowerRoof;
import twilightforest.structures.lichtower.ComponentTFTowerWing;

public class ComponentTFTowerRoofStairsOverhang
extends ComponentTFTowerRoof {
    public ComponentTFTowerRoofStairsOverhang() {
    }

    public ComponentTFTowerRoofStairsOverhang(int i, ComponentTFTowerWing wing) {
        super(i, wing);
        this.setCoordBaseMode(0);
        this.size = wing.size + 2;
        this.height = this.size / 2;
        this.boundingBox = new StructureBoundingBox(wing.getBoundingBox().minX - 1, wing.getBoundingBox().maxY, wing.getBoundingBox().minZ - 1, wing.getBoundingBox().maxX + 1, wing.getBoundingBox().maxY + this.height - 1, wing.getBoundingBox().maxZ + 1);
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        for (int y = 0; y <= this.height; ++y) {
            int min = y;
            int max = this.size - y - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == min) {
                        if (z == min || z == max) {
                            this.placeBlockAtCurrentPosition(world, (Block)Blocks.wooden_slab, 2, x, y, z, sbb);
                            continue;
                        }
                        this.placeBlockAtCurrentPosition(world, Blocks.birch_stairs, 0, x, y, z, sbb);
                        continue;
                    }
                    if (x == max) {
                        if (z == min || z == max) {
                            this.placeBlockAtCurrentPosition(world, (Block)Blocks.wooden_slab, 2, x, y, z, sbb);
                            continue;
                        }
                        this.placeBlockAtCurrentPosition(world, Blocks.birch_stairs, 1, x, y, z, sbb);
                        continue;
                    }
                    if (z == max) {
                        this.placeBlockAtCurrentPosition(world, Blocks.birch_stairs, 3, x, y, z, sbb);
                        continue;
                    }
                    if (z == min) {
                        this.placeBlockAtCurrentPosition(world, Blocks.birch_stairs, 2, x, y, z, sbb);
                        continue;
                    }
                    this.placeBlockAtCurrentPosition(world, Blocks.planks, 2, x, y, z, sbb);
                }
            }
        }
        return true;
    }
}

