/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.minotaurmaze;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.minotaurmaze.ComponentTFMazeUpperEntrance;

public class ComponentTFMazeMound
extends StructureTFComponent {
    public static final int DIAMETER = 35;
    private int averageGroundLevel = -1;
    private ComponentTFMazeUpperEntrance mazeAbove;

    public ComponentTFMazeMound() {
    }

    public ComponentTFMazeMound(int i, Random rand, int x, int y, int z) {
        super(i);
        this.coordBaseMode = rand.nextInt(4);
        this.boundingBox = new StructureBoundingBox(x, y, z, x + 35, y + 8, z + 35);
    }

    public void buildComponent(StructureComponent structurecomponent, List list, Random random) {
        super.buildComponent(structurecomponent, list, random);
        this.mazeAbove = new ComponentTFMazeUpperEntrance(3, random, this.boundingBox.minX + 10, this.boundingBox.minY + 0, this.boundingBox.minZ + 10);
        list.add(this.mazeAbove);
        this.mazeAbove.buildComponent(this, list, random);
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.getAverageGroundLevel(world, sbb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            int offset = this.averageGroundLevel - this.boundingBox.maxY + 8 - 1;
            this.boundingBox.offset(0, offset, 0);
            if (this.mazeAbove != null) {
                this.mazeAbove.getBoundingBox().offset(0, offset, 0);
            }
        }
        for (int x = 0; x < 35; ++x) {
            for (int z = 0; z < 35; ++z) {
                int cx = x - 17;
                int cz = z - 17;
                int dist = (int)Math.sqrt(cx * cx + cz * cz);
                int hheight = (int)(Math.cos((double)dist / 35.0 * Math.PI) * 11.0);
                if (cx <= 2 && cx >= -1 && cz <= 2 && cz >= -1 || (cx <= 2 && cx >= -1 || cz <= 2 && cz >= -1) && hheight <= 6) continue;
                this.placeBlockAtCurrentPosition(world, (Block)Blocks.grass, 0, x, hheight, z, sbb);
                if (!(cx <= 2 && cx >= -1 || cz <= 2 && cz >= -1)) {
                    this.func_151554_b(world, Blocks.dirt, 0, x, hheight - 1, z, sbb);
                    continue;
                }
                if (hheight <= 6) continue;
                this.fillWithBlocks(world, sbb, x, 6, z, x, hheight - 1, z, Blocks.dirt, Blocks.air, false);
            }
        }
        return true;
    }

    @Override
    protected int getAverageGroundLevel(World par1World, StructureBoundingBox par2StructureBoundingBox) {
        int totalHeight = 0;
        int totalMeasures = 0;
        for (int var5 = this.boundingBox.minZ; var5 <= this.boundingBox.maxZ; ++var5) {
            for (int var6 = this.boundingBox.minX; var6 <= this.boundingBox.maxX; ++var6) {
                if (!par2StructureBoundingBox.isVecInside(var6, 64, var5)) continue;
                totalHeight += Math.max(par1World.getTopSolidOrLiquidBlock(var6, var5), par1World.provider.getAverageGroundLevel());
                ++totalMeasures;
            }
        }
        if (totalMeasures == 0) {
            return -1;
        }
        return totalHeight / totalMeasures;
    }
}

