/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.minotaurmaze;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import twilightforest.structures.minotaurmaze.ComponentTFMazeRoom;

public class ComponentTFMazeMushRoom
extends ComponentTFMazeRoom {
    public ComponentTFMazeMushRoom() {
    }

    public ComponentTFMazeMushRoom(int i, Random rand, int x, int y, int z) {
        super(i, rand, x, y, z);
        this.coordBaseMode = 0;
    }

    @Override
    public boolean addComponentParts(World world, Random rand, StructureBoundingBox sbb) {
        super.addComponentParts(world, rand, sbb);
        for (int x = 1; x < 14; ++x) {
            for (int z = 1; z < 14; ++z) {
                int dist = (int)Math.round(7.0 / Math.sqrt((7.5 - (double)x) * (7.5 - (double)x) + (7.5 - (double)z) * (7.5 - (double)z)));
                if (rand.nextInt(dist + 1) > 0) {
                    this.placeBlockAtCurrentPosition(world, (Block)Blocks.mycelium, 0, x, 0, z, sbb);
                }
                if (rand.nextInt(dist) <= 0) continue;
                this.placeBlockAtCurrentPosition(world, (Block)(rand.nextBoolean() ? Blocks.red_mushroom : Blocks.brown_mushroom), 0, x, 1, z, sbb);
            }
        }
        this.makeMediumMushroom(world, sbb, 5, 2, 9, Blocks.red_mushroom_block);
        this.makeMediumMushroom(world, sbb, 5, 3, 9, Blocks.red_mushroom_block);
        this.makeMediumMushroom(world, sbb, 9, 2, 5, Blocks.red_mushroom_block);
        this.makeMediumMushroom(world, sbb, 6, 3, 4, Blocks.brown_mushroom_block);
        this.makeMediumMushroom(world, sbb, 10, 1, 9, Blocks.brown_mushroom_block);
        this.placeBlockAtCurrentPosition(world, Blocks.red_mushroom_block, 15, 1, 2, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.red_mushroom_block, 5, 1, 3, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.red_mushroom_block, 9, 2, 3, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.red_mushroom_block, 9, 1, 3, 2, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 15, 14, 3, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 5, 14, 4, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 7, 13, 4, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 7, 14, 4, 2, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 15, 1, 1, 14, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 5, 1, 2, 14, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 3, 2, 2, 14, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 3, 1, 2, 13, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 5, 14, 1, 14, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 1, 13, 1, 14, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brown_mushroom_block, 1, 14, 1, 13, sbb);
        return true;
    }

    private void makeMediumMushroom(World world, StructureBoundingBox sbb, int mx, int my, int mz, Block redMushroomBlock) {
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 5, mx + 0, my, mz + 0, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 6, mx + 1, my, mz + 0, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 9, mx + 1, my, mz + 1, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 8, mx + 0, my, mz + 1, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 7, mx - 1, my, mz + 1, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 4, mx - 1, my, mz + 0, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 1, mx - 1, my, mz - 1, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 2, mx + 0, my, mz - 1, sbb);
        this.placeBlockAtCurrentPosition(world, redMushroomBlock, 3, mx + 1, my, mz - 1, sbb);
        for (int y = 1; y < my; ++y) {
            this.placeBlockAtCurrentPosition(world, redMushroomBlock, 10, mx + 0, y, mz + 0, sbb);
        }
    }
}

