/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class TileEntityTFBossSpawner
extends TileEntity {
    protected String mobID = "Pig";
    protected int counter;
    protected Entity displayCreature = null;

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, (double)this.getRange()) != null;
    }

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        ++this.counter;
        if (this.anyPlayerInRange()) {
            if (this.worldObj.isRemote) {
                double rx = (float)this.xCoord + this.worldObj.rand.nextFloat();
                double ry = (float)this.yCoord + this.worldObj.rand.nextFloat();
                double rz = (float)this.zCoord + this.worldObj.rand.nextFloat();
                this.worldObj.spawnParticle("smoke", rx, ry, rz, 0.0, 0.0, 0.0);
                this.worldObj.spawnParticle("flame", rx, ry, rz, 0.0, 0.0, 0.0);
            } else if (this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL) {
                this.spawnMyBoss();
                this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, Blocks.air, 0, 2);
            }
        }
    }

    protected void spawnMyBoss() {
        EntityLiving myCreature = this.makeMyCreature();
        double rx = (double)this.xCoord + 0.5;
        double ry = (double)this.yCoord + 0.5;
        double rz = (double)this.zCoord + 0.5;
        myCreature.setLocationAndAngles(rx, ry, rz, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
        this.initializeCreature(myCreature);
        this.worldObj.spawnEntityInWorld((Entity)myCreature);
    }

    public Entity getDisplayEntity() {
        if (this.displayCreature == null) {
            this.displayCreature = this.makeMyCreature();
        }
        return this.displayCreature;
    }

    protected void initializeCreature(EntityLiving myCreature) {
        if (myCreature instanceof EntityCreature) {
            ((EntityCreature)myCreature).setHomeArea(this.xCoord, this.yCoord, this.zCoord, 46);
        }
    }

    protected int getRange() {
        return 50;
    }

    protected EntityLiving makeMyCreature() {
        return (EntityLiving)EntityList.createEntityByName((String)this.mobID, (World)this.worldObj);
    }
}

