/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.oredict.OreDictionary;
import twilightforest.block.BlockTFCinderFurnace;
import twilightforest.block.TFBlocks;

public class TileEntityTFCinderFurnace
extends TileEntity
implements ISidedInventory {
    private static final int SMELT_LOG_FACTOR = 10;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_OUTPUT = 2;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    private String customName;

    public int getSizeInventory() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.furnaceItemStacks[slot];
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (this.furnaceItemStacks[slot] != null) {
            if (this.furnaceItemStacks[slot].stackSize <= amount) {
                ItemStack itemstack = this.furnaceItemStacks[slot];
                this.furnaceItemStacks[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceItemStacks[slot].splitStack(amount);
            if (this.furnaceItemStacks[slot].stackSize == 0) {
                this.furnaceItemStacks[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.furnaceItemStacks[slot] != null) {
            ItemStack itemstack = this.furnaceItemStacks[slot];
            this.furnaceItemStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack) {
        this.furnaceItemStacks[slot] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "twilightforest.container.furnace";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        NBTTagList nbttaglist = nbtTags.getTagList("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            byte slot = nbttagcompound1.getByte("Slot");
            if (slot < 0 || slot >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = nbtTags.getShort("BurnTime");
        this.furnaceCookTime = nbtTags.getShort("CookTime");
        this.currentItemBurnTime = TileEntityTFCinderFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
        if (nbtTags.hasKey("CustomName", 8)) {
            this.customName = nbtTags.getString("CustomName");
        }
    }

    public void writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.setShort("BurnTime", (short)this.furnaceBurnTime);
        nbtTags.setShort("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            this.furnaceItemStacks[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbtTags.setTag("Items", (NBTBase)nbttaglist);
        if (this.hasCustomInventoryName()) {
            nbtTags.setString("CustomName", this.customName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int p_145953_1_) {
        return this.furnaceCookTime * p_145953_1_ / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int p_145955_1_) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * p_145955_1_ / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void updateEntity() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.worldObj.isRemote) {
            if (this.furnaceBurnTime != 0 || this.furnaceItemStacks[1] != null && this.furnaceItemStacks[0] != null) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityTFCinderFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
                    if (this.furnaceBurnTime > 0) {
                        flag1 = true;
                        if (this.furnaceItemStacks[1] != null) {
                            --this.furnaceItemStacks[1].stackSize;
                            if (this.furnaceItemStacks[1].stackSize == 0) {
                                this.furnaceItemStacks[1] = this.furnaceItemStacks[1].getItem().getContainerItem(this.furnaceItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    int speedMultiplier = this.getCurrentSpeedMultiplier();
                    this.furnaceCookTime += speedMultiplier;
                    if (this.furnaceCookTime >= 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                BlockTFCinderFurnace.updateFurnaceBlockState(this.furnaceBurnTime > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
            if (this.isBurning() && this.furnaceBurnTime % 5 == 0) {
                this.cinderizeNearbyLog();
            }
        }
        if (flag1) {
            this.markDirty();
        }
    }

    private void cinderizeNearbyLog() {
        Block nearbyBlock;
        int dz;
        int dy;
        Random rand = this.getWorldObj().rand;
        int dx = rand.nextInt(2) - rand.nextInt(2);
        if (this.worldObj.blockExists(this.xCoord + dx, this.yCoord + (dy = rand.nextInt(2) - rand.nextInt(2)), this.zCoord + (dz = rand.nextInt(2) - rand.nextInt(2))) && (nearbyBlock = this.getWorldObj().getBlock(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz)) != TFBlocks.cinderLog && this.isLog(nearbyBlock)) {
            this.getWorldObj().setBlock(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz, TFBlocks.cinderLog, this.getCinderMetaFor(dx, dy, dz), 2);
            this.getWorldObj().playAuxSFX(2004, this.xCoord + dx, this.yCoord + dy, this.zCoord + dz, 0);
            this.getWorldObj().playAuxSFX(2004, this.xCoord + dx, this.yCoord + dy, this.zCoord + dz, 0);
            this.getWorldObj().playSoundEffect((double)((float)(this.xCoord + dx) + 0.5f), (double)((float)(this.yCoord + dy) + 0.5f), (double)((float)(this.zCoord + dz) + 0.5f), "fire.fire", 1.0f, 1.0f);
        }
    }

    private int getCinderMetaFor(int dx, int dy, int dz) {
        if (dz == 0 && dx != 0) {
            return dy == 0 ? 4 : 8;
        }
        if (dx == 0 && dz != 0) {
            return dy == 0 ? 8 : 4;
        }
        if (dx == 0 && dz == 0) {
            return 0;
        }
        return dy == 0 ? 0 : 12;
    }

    private boolean isLog(Block nearbyBlock) {
        int[] oreIDs;
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(nearbyBlock))) {
            if (id != OreDictionary.getOreID((String)"logWood")) continue;
            return true;
        }
        return false;
    }

    private int getCurrentSpeedMultiplier() {
        return this.getCurrentMultiplier(2);
    }

    private int getCurrentMultiplier(int factor) {
        int logs = this.countNearbyLogs();
        if (logs < factor) {
            return 1;
        }
        return logs / factor + (this.worldObj.rand.nextInt(factor) >= logs % factor ? 0 : 1);
    }

    private int countNearbyLogs() {
        int count = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (!this.worldObj.blockExists(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz) || this.getWorldObj().getBlock(this.xCoord + dx, this.yCoord + dy, this.zCoord + dz) != TFBlocks.cinderLog) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack outputStack = FurnaceRecipes.smelting().getSmeltingResult(this.furnaceItemStacks[0]);
        if (outputStack == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].isItemEqual(outputStack)) {
            return false;
        }
        int resultStackSize = this.furnaceItemStacks[2].stackSize + this.getMaxOutputStacks(this.furnaceItemStacks[0], outputStack);
        return resultStackSize <= this.getInventoryStackLimit() && resultStackSize <= this.furnaceItemStacks[2].getMaxStackSize();
    }

    public int getMaxOutputStacks(ItemStack input, ItemStack output) {
        if (this.canMultiply(input, output)) {
            return output.stackSize * this.getCurrentMaxSmeltMultiplier();
        }
        return output.stackSize;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            int smeltMultiplier;
            ItemStack outputStack = FurnaceRecipes.smelting().getSmeltingResult(this.furnaceItemStacks[0]);
            if (this.canMultiply(this.furnaceItemStacks[0], outputStack) && (smeltMultiplier = this.getCurrentSmeltMultiplier()) > 1) {
                outputStack = outputStack.copy();
                outputStack.stackSize *= smeltMultiplier;
            }
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = outputStack.copy();
            } else if (this.furnaceItemStacks[2].getItem() == outputStack.getItem()) {
                this.furnaceItemStacks[2].stackSize += outputStack.stackSize;
            }
            --this.furnaceItemStacks[0].stackSize;
            if (this.furnaceItemStacks[0].stackSize <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public boolean canMultiply(ItemStack input, ItemStack output) {
        int[] oreIDs;
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)input)) {
            if (OreDictionary.getOreName((int)id).startsWith("ore")) {
                return true;
            }
            if (id != OreDictionary.getOreID((String)"logWood")) continue;
            return true;
        }
        return false;
    }

    private int getCurrentSmeltMultiplier() {
        return this.getCurrentMultiplier(10);
    }

    private int getCurrentMaxSmeltMultiplier() {
        return (int)Math.ceil((float)this.countNearbyLogs() / 10.0f);
    }

    public static int getItemBurnTime(ItemStack p_145952_0_) {
        if (p_145952_0_ == null) {
            return 0;
        }
        Item item = p_145952_0_.getItem();
        if (item instanceof ItemBlock && Block.getBlockFromItem((Item)item) != Blocks.air) {
            Block block = Block.getBlockFromItem((Item)item);
            if (block == Blocks.wooden_slab) {
                return 150;
            }
            if (block.getMaterial() == Material.wood) {
                return 300;
            }
            if (block == Blocks.coal_block) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item == Items.stick) {
            return 100;
        }
        if (item == Items.coal) {
            return 1600;
        }
        if (item == Items.lava_bucket) {
            return 20000;
        }
        if (item == Item.getItemFromBlock((Block)Blocks.sapling)) {
            return 100;
        }
        if (item == Items.blaze_rod) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)p_145952_0_);
    }

    public static boolean isItemFuel(ItemStack p_145954_0_) {
        return TileEntityTFCinderFurnace.getItemBurnTime(p_145954_0_) > 0;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemStack) {
        return slot == 2 ? false : (slot == 1 ? TileEntityFurnace.isItemFuel((ItemStack)itemStack) : true);
    }

    public int[] getAccessibleSlotsFromSide(int p_94128_1_) {
        return p_94128_1_ == 0 ? slotsBottom : (p_94128_1_ == 1 ? slotsTop : slotsSides);
    }

    public boolean canInsertItem(int slot, ItemStack itemStack, int side) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    public boolean canExtractItem(int slot, ItemStack itemStack, int side) {
        return side != 0 || slot != 1 || itemStack.getItem() == Items.bucket;
    }
}

