/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import net.minecraft.entity.Entity;
import twilightforest.entity.passive.EntityTFTinyFirefly;
import twilightforest.tileentity.TileEntityTFCritter;

public class TileEntityTFFirefly
extends TileEntityTFCritter {
    public int yawDelay;
    public int currentYaw;
    public int desiredYaw;
    public float glowIntensity;
    public boolean glowing;
    public int glowDelay;

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.anyPlayerInRange() && this.worldObj.rand.nextInt(20) == 0) {
            this.doFireflyFX();
        }
        if (this.yawDelay > 0) {
            --this.yawDelay;
        } else {
            if (this.currentYaw == 0 && this.desiredYaw == 0) {
                this.yawDelay = 200 + this.worldObj.rand.nextInt(200);
                this.desiredYaw = this.worldObj.rand.nextInt(15) - this.worldObj.rand.nextInt(15);
            }
            if (this.currentYaw < this.desiredYaw) {
                ++this.currentYaw;
            }
            if (this.currentYaw > this.desiredYaw) {
                --this.currentYaw;
            }
            if (this.currentYaw == this.desiredYaw) {
                this.desiredYaw = 0;
            }
        }
        if (this.glowDelay > 0) {
            --this.glowDelay;
        } else {
            if (this.glowing && (double)this.glowIntensity >= 1.0) {
                this.glowing = false;
            }
            if (this.glowing && (double)this.glowIntensity < 1.0) {
                this.glowIntensity = (float)((double)this.glowIntensity + 0.05);
            }
            if (!this.glowing && this.glowIntensity > 0.0f) {
                this.glowIntensity = (float)((double)this.glowIntensity - 0.05);
            }
            if (!this.glowing && this.glowIntensity <= 0.0f) {
                this.glowing = true;
                this.glowDelay = this.worldObj.rand.nextInt(50);
            }
        }
    }

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    void doFireflyFX() {
        double rx = (float)this.xCoord + this.worldObj.rand.nextFloat();
        double ry = (float)this.yCoord + this.worldObj.rand.nextFloat();
        double rz = (float)this.zCoord + this.worldObj.rand.nextFloat();
        EntityTFTinyFirefly tinyfly = new EntityTFTinyFirefly(this.worldObj, rx, ry, rz);
        this.worldObj.addWeatherEffect((Entity)tinyfly);
    }
}

