/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import twilightforest.entity.TFCreatures;
import twilightforest.entity.boss.EntityTFKnightPhantom;
import twilightforest.tileentity.TileEntityTFBossSpawner;

public class TileEntityTFKnightPhantomsSpawner
extends TileEntityTFBossSpawner {
    public TileEntityTFKnightPhantomsSpawner() {
        this.mobID = TFCreatures.getSpawnerNameFor("Knight Phantom");
    }

    @Override
    public boolean anyPlayerInRange() {
        EntityPlayer closestPlayer = this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 9.0);
        return closestPlayer != null && closestPlayer.posY > (double)(this.yCoord - 2);
    }

    @Override
    protected void spawnMyBoss() {
        for (int i = 0; i < 6; ++i) {
            EntityLiving myCreature = this.makeMyCreature();
            float angle = 60.0f * (float)i;
            float distance = 4.0f;
            double rx = (double)this.xCoord + 0.5 + Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
            double ry = (double)this.yCoord + 0.5;
            double rz = (double)this.zCoord + 0.5 + Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
            myCreature.setLocationAndAngles(rx, ry, rz, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
            this.initializeCreature(myCreature);
            ((EntityTFKnightPhantom)myCreature).setNumber(i);
            this.worldObj.spawnEntityInWorld((Entity)myCreature);
        }
    }

    @Override
    protected void initializeCreature(EntityLiving myCreature) {
        if (myCreature instanceof EntityTFKnightPhantom) {
            ((EntityTFKnightPhantom)myCreature).setHomeArea(this.xCoord, this.yCoord, this.zCoord, 46);
        }
    }
}

