/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenCanopyTree;
import twilightforest.world.TFWorld;

public class TFGenCanopyOak
extends TFGenCanopyTree {
    public TFGenCanopyOak() {
        this(false);
    }

    public TFGenCanopyOak(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log;
        this.treeMeta = 0;
        this.branchMeta = 12;
        this.leafBlock = TFBlocks.leaves;
        this.leafMeta = 0;
        this.rootBlock = TFBlocks.root;
        this.rootMeta = 0;
    }

    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        Material materialUnder = world.getBlock(x, y - 1, z).getMaterial();
        if (materialUnder != Material.grass && materialUnder != Material.ground || y >= TFWorld.MAXHEIGHT - 12) {
            return false;
        }
        int treeHeight = this.minHeight;
        if (random.nextInt(this.chanceAddFirstFive) == 0) {
            treeHeight += random.nextInt(5);
            if (random.nextInt(this.chanceAddSecondFive) == 0) {
                treeHeight += random.nextInt(5);
            }
        }
        this.buildTrunk(world, x, y, z, treeHeight);
        int numBranches = 12 + random.nextInt(9);
        float bangle = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            float btilt = 0.15f + random.nextFloat() * 0.35f;
            this.buildBranch(world, x, y, z, treeHeight - 10 + b / 2, 5.0, bangle, btilt, false, random);
            bangle += random.nextFloat() * 0.4f;
            if (!(bangle > 1.0f)) continue;
            bangle -= 1.0f;
        }
        this.makeRoots(world, random, x + 0, y, z + 0);
        this.makeRoots(world, random, x + 1, y, z + 0);
        this.makeRoots(world, random, x + 0, y, z + 1);
        this.makeRoots(world, random, x + 1, y, z + 1);
        return true;
    }

    private void makeRoots(World world, Random random, int x, int y, int z) {
        if (TFGenCanopyOak.hasAirAround(world, x, y - 1, z)) {
            this.setBlockAndMetadata(world, x, y - 1, z, this.treeBlock, this.treeMeta);
        } else {
            this.setBlockAndMetadata(world, x, y - 1, z, this.rootBlock, this.rootMeta);
        }
        int numRoots = 1 + random.nextInt(2);
        float offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, x, y, z, offset, b);
        }
    }

    private void buildTrunk(World world, int sx, int sy, int sz, int treeHeight) {
        for (int dy = 0; dy < treeHeight; ++dy) {
            this.setBlockAndMetadata(world, sx + 0, sy + dy, sz + 0, this.treeBlock, this.treeMeta);
            this.setBlockAndMetadata(world, sx + 1, sy + dy, sz + 0, this.treeBlock, this.treeMeta);
            this.setBlockAndMetadata(world, sx + 0, sy + dy, sz + 1, this.treeBlock, this.treeMeta);
            this.setBlockAndMetadata(world, sx + 1, sy + dy, sz + 1, this.treeBlock, this.treeMeta);
        }
        this.drawLeafBlob(world, sx + 0, sy + treeHeight, sz + 0, 3, this.leafBlock, this.leafMeta);
    }

    @Override
    void buildBranch(World world, int x, int y, int z, int height, double length, double angle, double tilt, boolean trunk, Random treeRNG) {
        ChunkCoordinates src = new ChunkCoordinates(x, y + height, z);
        ChunkCoordinates dest = TFGenCanopyOak.translateCoords(src.posX, src.posY, src.posZ, length, angle, tilt);
        int limit = 5;
        if (dest.posX - x < -limit) {
            dest.posX = x - limit;
        }
        if (dest.posX - x > limit) {
            dest.posX = x + limit;
        }
        if (dest.posZ - z < -limit) {
            dest.posZ = z - limit;
        }
        if (dest.posZ - z > limit) {
            dest.posZ = z + limit;
        }
        this.drawBresehnam(world, src.posX, src.posY, src.posZ, dest.posX, dest.posY, dest.posZ, this.treeBlock, trunk ? this.treeMeta : this.branchMeta);
        if (trunk) {
            this.addFirefly(world, x, y, z, 3 + treeRNG.nextInt(7), treeRNG.nextDouble());
        }
        int blobSize = 2;
        this.drawLeafBlob(world, dest.posX, dest.posY, dest.posZ, blobSize, this.leafBlock, this.leafMeta);
        this.setBlockAndMetadata(world, dest.posX + 1, dest.posY, dest.posZ, this.treeBlock, this.branchMeta);
        this.setBlockAndMetadata(world, dest.posX - 1, dest.posY, dest.posZ, this.treeBlock, this.branchMeta);
        this.setBlockAndMetadata(world, dest.posX, dest.posY, dest.posZ + 1, this.treeBlock, this.branchMeta);
        this.setBlockAndMetadata(world, dest.posX, dest.posY, dest.posZ - 1, this.treeBlock, this.branchMeta);
    }
}

