/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFGenDarkCanopyTree
extends TFTreeGenerator {
    public TFGenDarkCanopyTree() {
        this(false);
    }

    public TFGenDarkCanopyTree(boolean par1) {
        super(par1);
        this.treeBlock = TFBlocks.log;
        this.treeMeta = 3;
        this.branchMeta = 15;
        this.leafBlock = TFBlocks.darkleaves;
        this.leafMeta = 0;
        this.rootBlock = TFBlocks.root;
        this.rootMeta = 0;
    }

    public boolean generate(World world, Random random, int x, int y, int z) {
        boolean foundDirt = false;
        for (int dy = y; dy >= TFWorld.SEALEVEL; --dy) {
            Material materialUnder = world.getBlock(x, dy - 1, z).getMaterial();
            if (materialUnder == Material.grass || materialUnder == Material.ground) {
                foundDirt = true;
                y = dy;
                break;
            }
            if (materialUnder == Material.rock || materialUnder == Material.sand) break;
        }
        if (!foundDirt) {
            return false;
        }
        if (world.getBlock(x + 1, y, z + 0).getMaterial() == Material.wood || world.getBlock(x - 1, y, z + 0).getMaterial() == Material.wood || world.getBlock(x + 0, y, z + 1).getMaterial() == Material.wood || world.getBlock(x + 0, y, z - 1).getMaterial() == Material.wood) {
            return false;
        }
        int treeHeight = 6 + random.nextInt(5);
        this.drawBresehnam(world, x, y, z, x, y + treeHeight, z, this.treeBlock, this.treeMeta);
        this.leafAround(world, x, y + treeHeight, z);
        int numBranches = 4;
        double offset = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch(world, x, y, z, treeHeight - 3 - numBranches + b / 2, 10 + random.nextInt(4), 0.23 * (double)b + offset, 0.23, random);
        }
        if (TFGenDarkCanopyTree.hasAirAround(world, x, y - 1, z)) {
            this.setBlockAndMetadata(world, x, y - 1, z, this.treeBlock, this.treeMeta);
        } else {
            this.setBlockAndMetadata(world, x, y - 1, z, this.rootBlock, this.rootMeta);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextDouble();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, x, y, z, offset, b);
        }
        return true;
    }

    void buildBranch(World world, int x, int y, int z, int height, double length, double angle, double tilt, Random random) {
        ChunkCoordinates src = new ChunkCoordinates(x, y + height, z);
        ChunkCoordinates dest = TFGenDarkCanopyTree.translateCoords(src.posX, src.posY, src.posZ, length, angle, tilt);
        if (dest.posX - x < -4) {
            dest.posX = x - 4;
        }
        if (dest.posX - x > 4) {
            dest.posX = x + 4;
        }
        if (dest.posZ - z < -4) {
            dest.posZ = z - 4;
        }
        if (dest.posZ - z > 4) {
            dest.posZ = z + 4;
        }
        this.drawBresehnam(world, src.posX, src.posY, src.posZ, dest.posX, dest.posY, dest.posZ, this.treeBlock, this.branchMeta);
        if (Math.abs(x - dest.posX) + 2 > 7 || Math.abs(z - dest.posZ) + 2 > 7) {
            System.out.println("getting branch too far.  x = " + (x - dest.posX + 2) + ", z = " + (z - dest.posZ + 2));
        }
        this.leafAround(world, dest.posX, dest.posY, dest.posZ);
    }

    private void leafAround(World world, int dx, int dy, int dz) {
        int leafSize = 4;
        if (TFGenDarkCanopyTree.hasAirAround(world, dx, dy, dz)) {
            this.makeLeafCircle(world, dx, dy - 1, dz, leafSize, this.leafBlock, this.leafMeta);
            this.makeLeafCircle(world, dx, dy, dz, leafSize + 1, this.leafBlock, this.leafMeta);
            this.makeLeafCircle(world, dx, dy + 1, dz, leafSize, this.leafBlock, this.leafMeta);
            this.makeLeafCircle(world, dx, dy + 2, dz, leafSize - 2, this.leafBlock, this.leafMeta);
        }
    }
}

