/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFTreeGenerator;

public class TFGenWoodRoots
extends TFGenerator {
    private Block rootBlock = TFBlocks.root;
    private int rootMeta = 0;
    private Block oreBlock = TFBlocks.root;
    private int oreMeta = 1;

    public boolean generate(World world, Random rand, int x, int y, int z) {
        if (world.getBlock(x, y, z) != Blocks.stone) {
            return false;
        }
        float length = rand.nextFloat() * 6.0f + rand.nextFloat() * 6.0f + 4.0f;
        if (length > (float)y) {
            length = y;
        }
        float tilt = 0.6f + rand.nextFloat() * 0.3f;
        return this.drawRoot(world, rand, x, y, z, length, rand.nextFloat(), tilt);
    }

    private boolean drawRoot(World world, Random rand, int x, int y, int z, float length, float angle, float tilt) {
        return this.drawRoot(world, rand, x, y, z, x, y, z, length, angle, tilt);
    }

    private boolean drawRoot(World world, Random rand, int ox, int oy, int oz, int x, int y, int z, float length, float angle, float tilt) {
        ChunkCoordinates[] lineArray;
        int limit = 6;
        int[] dest = TFGenWoodRoots.translate(x, y, z, length, angle, tilt);
        if (ox + limit < dest[0]) {
            dest[0] = ox + limit;
        }
        if (ox - limit > dest[0]) {
            dest[0] = ox - limit;
        }
        if (oz + limit < dest[2]) {
            dest[2] = oz + limit;
        }
        if (oz - limit > dest[2]) {
            dest[2] = oz - limit;
        }
        if (world.getBlock(dest[0], dest[1], dest[2]) != Blocks.stone) {
            return false;
        }
        for (ChunkCoordinates coord : lineArray = TFGenWoodRoots.getBresehnamArrayCoords(x, y, z, dest[0], dest[1], dest[2])) {
            this.placeRootBlock(world, coord.posX, coord.posY, coord.posZ, this.rootBlock, this.rootMeta);
        }
        if (length > 8.0f && rand.nextInt(3) > 0) {
            int[] nextSrc = TFGenWoodRoots.translate(x, y, z, length / 2.0f, angle, tilt);
            float nextAngle = (angle + 0.25f + rand.nextFloat() * 0.5f) % 1.0f;
            float nextTilt = 0.6f + rand.nextFloat() * 0.3f;
            this.drawRoot(world, rand, ox, oy, oz, nextSrc[0], nextSrc[1], nextSrc[2], length / 2.0f, nextAngle, nextTilt);
        }
        if (length > 6.0f && rand.nextInt(4) == 0) {
            int[] ballSrc = TFGenWoodRoots.translate(x, y, z, length / 2.0f, angle, tilt);
            int[] ballDest = TFGenWoodRoots.translate(ballSrc[0], ballSrc[1], ballSrc[2], 1.5, (angle + 0.5f) % 1.0f, 0.75);
            this.placeRootBlock(world, ballSrc[0], ballSrc[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballSrc[0], ballSrc[1], ballDest[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballSrc[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballSrc[1], ballDest[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballSrc[0], ballDest[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballSrc[0], ballDest[1], ballDest[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballDest[1], ballSrc[2], this.oreBlock, this.oreMeta);
            this.placeRootBlock(world, ballDest[0], ballDest[1], ballDest[2], this.oreBlock, this.oreMeta);
        }
        return true;
    }

    protected void placeRootBlock(World world, int x, int y, int z, Block rootBlock2, int meta) {
        if (TFTreeGenerator.canRootGrowIn(world, x, y, z)) {
            this.setBlockAndMetadata(world, x, y, z, rootBlock2, meta);
        }
    }
}

