/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.world.layer.GenLayerTF;

public class TFWorldChunkManager
extends WorldChunkManager {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private BiomeCache myBiomeCache = new BiomeCache((WorldChunkManager)this);
    private List<BiomeGenBase> myBiomesToSpawnIn = new ArrayList<BiomeGenBase>();

    protected TFWorldChunkManager() {
        this.myBiomesToSpawnIn.add(TFBiomeBase.twilightForest);
        this.myBiomesToSpawnIn.add(TFBiomeBase.twilightForest2);
        this.myBiomesToSpawnIn.add(TFBiomeBase.clearing);
        this.myBiomesToSpawnIn.add(TFBiomeBase.tfSwamp);
        this.myBiomesToSpawnIn.add(TFBiomeBase.mushrooms);
    }

    public TFWorldChunkManager(long par1, WorldType par3WorldType) {
        this();
        GenLayer[] agenlayer = TwilightForestMod.oldMapGen ? GenLayerTF.makeTheWorldOldMapGen(par1) : GenLayerTF.makeTheWorld(par1);
        this.unzoomedBiomes = agenlayer[0];
        this.zoomedBiomes = agenlayer[1];
    }

    public TFWorldChunkManager(World par1World) {
        this(par1World.getSeed(), par1World.getWorldInfo().getTerrainType());
    }

    public List getBiomesToSpawnIn() {
        return this.myBiomesToSpawnIn;
    }

    public BiomeGenBase getBiomeGenAt(int par1, int par2) {
        BiomeGenBase biome = this.myBiomeCache.getBiomeGenAt(par1, par2);
        if (biome == null) {
            return TFBiomeBase.twilightForest;
        }
        return biome;
    }

    public float[] getRainfall(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.resetIntCache();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] ai = this.zoomedBiomes.getInts(par2, par3, par4, par5);
        for (int i = 0; i < par4 * par5; ++i) {
            if (ai[i] < 0 || BiomeGenBase.getBiome((int)ai[i]) == null) continue;
            float f = (float)BiomeGenBase.getBiome((int)ai[i]).getIntRainfall() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            par1ArrayOfFloat[i] = f;
        }
        return par1ArrayOfFloat;
    }

    public float getTemperatureAtHeight(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] getBiomesForGeneration(BiomeGenBase[] par1ArrayOfBiomeGenBase, int x, int z, int length, int width) {
        IntCache.resetIntCache();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < length * width) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[length * width];
        }
        int[] arrayOfInts = this.unzoomedBiomes.getInts(x, z, length, width);
        for (int i = 0; i < length * width; ++i) {
            par1ArrayOfBiomeGenBase[i] = arrayOfInts[i] >= 0 ? BiomeGenBase.getBiome((int)arrayOfInts[i]) : TFBiomeBase.twilightForest;
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] loadBlockGeneratorData(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.getBiomeGenAt(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] getBiomeGenAt(BiomeGenBase[] par1ArrayOfBiomeGenBase, int x, int y, int width, int length, boolean cacheFlag) {
        IntCache.resetIntCache();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < width * length) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase = this.myBiomeCache.getCachedBiomes(x, y);
            System.arraycopy(abiomegenbase, 0, par1ArrayOfBiomeGenBase, 0, width * length);
            return par1ArrayOfBiomeGenBase;
        }
        int[] ai = this.zoomedBiomes.getInts(x, y, width, length);
        for (int i = 0; i < width * length; ++i) {
            par1ArrayOfBiomeGenBase[i] = ai[i] >= 0 ? BiomeGenBase.getBiome((int)ai[i]) : TFBiomeBase.twilightForest;
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean areBiomesViable(int par1, int par2, int par3, List par4List) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.unzoomedBiomes.getInts(i, j, i1, j1);
        for (int k1 = 0; k1 < i1 * j1; ++k1) {
            BiomeGenBase biomegenbase = BiomeGenBase.getBiome((int)ai[k1]);
            if (par4List.contains(biomegenbase)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition findBiomePosition(int par1, int par2, int par3, List par4List, Random par5Random) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] ai = this.unzoomedBiomes.getInts(i, j, i1, j1);
        ChunkPosition chunkposition = null;
        int k1 = 0;
        for (int l1 = 0; l1 < ai.length; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.getBiome((int)ai[l1]);
            if (!par4List.contains(biomegenbase) || chunkposition != null && par5Random.nextInt(k1 + 1) != 0) continue;
            chunkposition = new ChunkPosition(i2, 0, j2);
            ++k1;
        }
        return chunkposition;
    }

    public void cleanupCache() {
        this.myBiomeCache.cleanupCache();
    }

    public int getFeatureID(int mapX, int mapZ, World world) {
        return this.getFeatureAt((int)mapX, (int)mapZ, (World)world).featureID;
    }

    public TFFeature getFeatureAt(int mapX, int mapZ, World world) {
        return TFFeature.generateFeatureFor1Point7(mapX >> 4, mapZ >> 4, world);
    }

    public boolean isInFeatureChunk(World world, int mapX, int mapZ) {
        if (TwilightForestMod.oldMapGen) {
            return this.isInFeatureChunkOld(world, mapX, mapZ);
        }
        int chunkX = mapX >> 4;
        int chunkZ = mapZ >> 4;
        ChunkCoordinates cc = TFFeature.getNearestCenterXYZ(chunkX, chunkZ, world);
        return chunkX == cc.posX >> 4 && chunkZ == cc.posZ >> 4;
    }

    public boolean isInFeatureChunkOld(World world, int mapX, int mapZ) {
        int chunkX = mapX >> 4;
        int chunkZ = mapZ >> 4;
        return chunkX % 16 == 0 && chunkZ % 16 == 0;
    }
}

