/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomeBase;

public class GenLayerTFCompanionBiomes
extends GenLayer {
    public GenLayerTFCompanionBiomes(long l, GenLayer genlayer) {
        super(l);
        this.parent = genlayer;
    }

    public int[] getInts(int x, int z, int width, int depth) {
        int nx = x - 1;
        int nz = z - 1;
        int nwidth = width + 2;
        int ndepth = depth + 2;
        int[] input = this.parent.getInts(nx, nz, nwidth, ndepth);
        int[] output = IntCache.getIntCache((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int center = input[dx + 1 + (dz + 1) * nwidth];
                int right = input[dx + 0 + (dz + 1) * nwidth];
                int left = input[dx + 2 + (dz + 1) * nwidth];
                int up = input[dx + 1 + (dz + 0) * nwidth];
                int down = input[dx + 1 + (dz + 2) * nwidth];
                output[dx + dz * width] = this.isKey(TFBiomeBase.fireSwamp.biomeID, center, right, left, up, down) ? TFBiomeBase.tfSwamp.biomeID : (this.isKey(TFBiomeBase.glacier.biomeID, center, right, left, up, down) ? TFBiomeBase.tfSnow.biomeID : (this.isKey(TFBiomeBase.darkForestCenter.biomeID, center, right, left, up, down) ? TFBiomeBase.darkForest.biomeID : (this.isKey(TFBiomeBase.highlandsCenter.biomeID, center, right, left, up, down) ? TFBiomeBase.highlands.biomeID : center)));
            }
        }
        return output;
    }

    boolean isKey(int biome, int center, int right, int left, int up, int down) {
        return center != biome && (right == biome || left == biome || up == biome || down == biome);
    }
}

