/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomeBase;

public class GenLayerTFKeyBiomes
extends GenLayer {
    public GenLayerTFKeyBiomes(long l, GenLayer genlayer) {
        super(l);
        this.parent = genlayer;
    }

    public GenLayerTFKeyBiomes(long l) {
        super(l);
    }

    public int[] getInts(int x, int z, int width, int depth) {
        int[] src = this.parent.getInts(x, z, width, depth);
        int[] dest = IntCache.getIntCache((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                this.initChunkSeed(dx + x | 3, dz + z | 3);
                int ox = this.nextInt(3) + 1;
                int oz = this.nextInt(3) + 1;
                if ((dx + x & 3) == ox && (dz + z & 3) == oz) {
                    if ((dx + x & 4) == 0) {
                        if ((dz + z & 4) == 0) {
                            dest[dx + dz * width] = this.getKeyBiomeFor(dx + x, dz + z, 0);
                            continue;
                        }
                        dest[dx + dz * width] = this.getKeyBiomeFor(dx + x, dz + z, 1);
                        continue;
                    }
                    if ((dz + z & 4) == 0) {
                        dest[dx + dz * width] = this.getKeyBiomeFor(dx + x, dz + z, 2);
                        continue;
                    }
                    dest[dx + dz * width] = this.getKeyBiomeFor(dx + x, dz + z, 3);
                    continue;
                }
                dest[dx + dz * width] = src[dx + dz * width];
            }
        }
        return dest;
    }

    private int getKeyBiomeFor(int mapX, int mapZ, int index) {
        int regionX = mapX + 4 >> 3;
        int regionZ = mapZ + 4 >> 3;
        this.initChunkSeed(regionX, regionZ);
        int offset = this.nextInt(4);
        switch ((index + offset) % 4) {
            default: {
                return TFBiomeBase.glacier.biomeID;
            }
            case 1: {
                return TFBiomeBase.fireSwamp.biomeID;
            }
            case 2: {
                return TFBiomeBase.darkForestCenter.biomeID;
            }
            case 3: 
        }
        return TFBiomeBase.highlandsCenter.biomeID;
    }
}

