/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.ritual.Rite;
import com.emoniph.witchery.ritual.rites.RiteCurseCreature;
import com.emoniph.witchery.ritual.rites.RiteTeleportEntity;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Log;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class BlockAreaMarker
extends BlockBaseContainer {
    public BlockAreaMarker(Class<? extends TileEntityAreaMarker> clazzTile) {
        super(Material.rock, clazzTile);
        this.setBlockUnbreakable();
        this.setResistance(9999.0f);
        this.setHardness(2.5f);
        this.setStepSound(soundTypeStone);
        this.setBlockBounds(0.15f, 0.0f, 0.15f, 0.85f, 0.5f, 0.85f);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int l = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.setBlockMetadataWithNotify(x, y, z, 2, 2);
        }
        if (l == 1) {
            world.setBlockMetadataWithNotify(x, y, z, 5, 2);
        }
        if (l == 2) {
            world.setBlockMetadataWithNotify(x, y, z, 3, 2);
        }
        if (l == 3) {
            world.setBlockMetadataWithNotify(x, y, z, 4, 2);
        }
        if (!world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntity tile = world.getTileEntity(x, y, z);
            if (tile != null && tile instanceof TileEntityAreaMarker) {
                TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
                marker.setOwner(player.getCommandSenderName());
            }
        }
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile;
        if (!world.isRemote & player != null && (tile = world.getTileEntity(x, y, z)) != null && tile instanceof TileEntityAreaMarker) {
            TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
            if (player.capabilities.isCreativeMode || player.getCommandSenderName().equals(marker.getOwner()) && player.isSneaking()) {
                int dy = y;
                while (world.getBlock(x, dy, z) == this) {
                    world.setBlockToAir(x, dy, z);
                    world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)dy, 0.5 + (double)z, new ItemStack((Block)this)));
                    ++dy;
                }
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile != null && tile instanceof TileEntityAreaMarker) {
            TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
            return marker.activateBlock(world, x, y, z, player, side);
        }
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 0;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon("stone");
    }

    public static class AreaMarkerEventHooks {
        @SubscribeEvent(priority=EventPriority.NORMAL)
        public void onLivingDeath(LivingDeathEvent event) {
            if (!event.isCanceled() && !event.entityLiving.worldObj.isRemote && event.entityLiving instanceof EntityPlayer && event.source.getSourceOfDamage() != null && event.source.getSourceOfDamage() instanceof EntityPlayer && event.source.getSourceOfDamage() != event.entityLiving) {
                EntityPlayer attacker = (EntityPlayer)event.source.getSourceOfDamage();
                for (TileEntityAreaMarker tile : AreaMarkerRegistry.instance().tiles) {
                    if (!tile.isNear((EntityLivingBase)attacker)) continue;
                    tile.setKiller(attacker);
                }
            }
        }
    }

    public static abstract class TileEntityAreaMarker
    extends TileEntityBase {
        private static final String OWNER_KEY = "WITCPlacer";
        private String owner;
        private ArrayList<String> killers = new ArrayList();

        @Override
        protected void initiate() {
            super.initiate();
            if (!this.worldObj.isRemote) {
                if (this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord) == this.getExpectedBlockType()) {
                    AreaMarkerRegistry.instance().add(this);
                } else {
                    Log.instance().warning("Area Marker tile entity exists without a corresponding block at: " + this.xCoord + ", " + this.yCoord + ", " + this.zCoord);
                }
            }
        }

        public void invalidate() {
            super.invalidate();
            if (!this.worldObj.isRemote) {
                AreaMarkerRegistry.instance().remove(this);
            }
        }

        public void setOwner(String username) {
            this.owner = username;
        }

        public String getOwner() {
            return this.owner != null ? this.owner : "";
        }

        public void setKiller(EntityPlayer player) {
            String username = player.getCommandSenderName();
            if (!this.killers.contains(username)) {
                this.killers.add(username);
            }
        }

        public boolean checkIsProtected(EntityLivingBase entity, Rite rite) {
            if (this.isNear(entity)) {
                boolean killer = entity instanceof EntityPlayer && this.killers.contains(entity.getCommandSenderName());
                return this.isProtected(entity, killer, rite);
            }
            return false;
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            nbtTag.setString(OWNER_KEY, this.getOwner());
            NBTTagList nbtKillers = new NBTTagList();
            for (String killer : this.killers) {
                nbtKillers.appendTag((NBTBase)new NBTTagString(killer));
            }
            nbtTag.setTag("Killers", (NBTBase)nbtKillers);
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            super.readFromNBT(nbtTag);
            this.owner = nbtTag.hasKey(OWNER_KEY) ? nbtTag.getString(OWNER_KEY) : "";
            NBTTagList nbtKillers = nbtTag.getTagList("Killers", 8);
            int count = nbtKillers.tagCount();
            for (int i = 0; i < count; ++i) {
                this.killers.add(nbtKillers.getStringTagAt(i));
            }
        }

        public abstract boolean activateBlock(World var1, int var2, int var3, int var4, EntityPlayer var5, int var6);

        protected abstract boolean isNear(EntityLivingBase var1);

        protected abstract boolean isProtected(EntityLivingBase var1, boolean var2, Rite var3);

        protected abstract Block getExpectedBlockType();
    }

    public static class AreaMarkerRegistry {
        private static AreaMarkerRegistry INSTANCE_CLIENT;
        private static AreaMarkerRegistry INSTANCE_SERVER;
        private final ArrayList<TileEntityAreaMarker> tiles = new ArrayList();

        public static AreaMarkerRegistry instance() {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                return INSTANCE_SERVER;
            }
            return INSTANCE_CLIENT;
        }

        public static void serverStart() {
            INSTANCE_CLIENT = new AreaMarkerRegistry();
            INSTANCE_SERVER = new AreaMarkerRegistry();
        }

        private void add(TileEntityAreaMarker tile) {
            if (!this.tiles.contains((Object)tile)) {
                try {
                    Iterator<TileEntityAreaMarker> it = this.tiles.iterator();
                    while (it.hasNext()) {
                        TileEntityAreaMarker source = it.next();
                        if (source != null && !source.isInvalid() && (source.xCoord != tile.xCoord || source.yCoord != tile.yCoord || source.zCoord != tile.zCoord)) continue;
                        it.remove();
                    }
                }
                catch (Throwable e) {
                    Log.instance().warning(e, "Exception occured validating existing power source entries");
                }
                this.tiles.add(tile);
            }
        }

        private void remove(TileEntityAreaMarker tile) {
            if (this.tiles.contains((Object)tile)) {
                this.tiles.remove((Object)tile);
            }
            try {
                Iterator<TileEntityAreaMarker> it = this.tiles.iterator();
                while (it.hasNext()) {
                    TileEntityAreaMarker source = it.next();
                    if (source == null || source.isInvalid()) {
                        it.remove();
                        continue;
                    }
                    if (source.getWorldObj().getTileEntity(source.xCoord, source.yCoord, source.zCoord) == source) continue;
                    it.remove();
                }
            }
            catch (Throwable e) {
                Log.instance().warning(e, "Exception occured removing existing power source entries");
            }
        }

        public boolean isProtectionActive(EntityLivingBase entity, Rite rite) {
            for (TileEntityAreaMarker tile : this.tiles) {
                if (!tile.checkIsProtected(entity, rite)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TileEntityAreaTeleportPullProtect
    extends TileEntityAreaMarker {
        @Override
        public boolean activateBlock(World world, int x, int y, int z, EntityPlayer player, int side) {
            return false;
        }

        @Override
        protected boolean isProtected(EntityLivingBase entity, boolean killer, Rite rite) {
            return !killer && Config.instance().allowDecurseTeleport && (rite == null || rite instanceof RiteTeleportEntity);
        }

        @Override
        protected boolean isNear(EntityLivingBase entity) {
            int RADIUS = Config.instance().decurseTeleportPullRadius;
            int RADIUS_SQ = RADIUS * RADIUS;
            boolean inRange = Coord.distanceSq(entity.posX, 1.0, entity.posZ, this.xCoord, 1.0, this.zCoord) <= (double)RADIUS_SQ;
            return inRange && this.worldObj.provider.dimensionId == entity.dimension;
        }

        @Override
        protected Block getExpectedBlockType() {
            return Witchery.Blocks.DECURSE_TELEPORT;
        }
    }

    public static class TileEntityAreaCurseProtect
    extends TileEntityAreaMarker {
        @Override
        public boolean activateBlock(World world, int x, int y, int z, EntityPlayer player, int side) {
            return false;
        }

        @Override
        protected boolean isProtected(EntityLivingBase entity, boolean killer, Rite rite) {
            return !killer && Config.instance().allowDecurseDirected && (rite == null || rite instanceof RiteCurseCreature);
        }

        @Override
        protected boolean isNear(EntityLivingBase entity) {
            int RADIUS = Config.instance().decurseDirectedRadius;
            int RADIUS_SQ = RADIUS * RADIUS;
            boolean inRange = Coord.distanceSq(entity.posX, 1.0, entity.posZ, this.xCoord, 1.0, this.zCoord) <= (double)RADIUS_SQ;
            return inRange && this.worldObj.provider.dimensionId == entity.dimension;
        }

        @Override
        protected Block getExpectedBlockType() {
            return Witchery.Blocks.DECURSE_DIRECTED;
        }
    }
}

