/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.WitcheryCreativeTab;
import com.emoniph.witchery.util.BlockUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class BlockBaseContainer
extends BlockContainer {
    protected boolean registerBlockName = true;
    protected boolean registerTileEntity = true;
    protected boolean registerWithCreateTab = true;
    protected final Class<? extends TileEntity> clazzTile;
    protected final Class<? extends ItemBlock> clazzItem;

    public BlockBaseContainer(Material material, Class<? extends TileEntity> clazzTile) {
        this(material, clazzTile, null);
    }

    public BlockBaseContainer(Material material, Class<? extends TileEntity> clazzTile, Class<? extends ItemBlock> clazzItem) {
        super(material);
        this.clazzTile = clazzTile;
        this.clazzItem = clazzItem;
    }

    public Block setBlockName(String blockName) {
        if (this.registerWithCreateTab) {
            this.setCreativeTab(WitcheryCreativeTab.INSTANCE);
        }
        if (this.registerBlockName) {
            if (this.clazzItem == null) {
                BlockUtil.registerBlock((Block)this, blockName);
            } else {
                BlockUtil.registerBlock((Block)this, this.clazzItem, blockName);
            }
        }
        if (this.registerTileEntity) {
            GameRegistry.registerTileEntity(this.clazzTile, (String)blockName);
        }
        return super.setBlockName(blockName);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        try {
            return this.clazzTile.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

