/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.entity.EntityWolfman;
import com.emoniph.witchery.infusion.infusions.InfusionInfernal;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.CreatureUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import com.emoniph.witchery.util.TimeUtil;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBeartrap
extends BlockBaseContainer {
    private final boolean silvered;

    public BlockBeartrap(boolean silvered) {
        super(Material.iron, TileEntityBeartrap.class);
        this.silvered = silvered;
        this.setHardness(5.0f);
        this.setResistance(10.0f);
        this.setStepSound(soundTypeMetal);
        float w = 0.3f;
        this.setBlockBounds(0.19999999f, 0.01f, 0.19999999f, 0.8f, 0.1f, 0.8f);
    }

    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        TileEntityBeartrap tile = new TileEntityBeartrap(this.silvered);
        return tile;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        switch (MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) {
            case 0: {
                world.setBlockMetadataWithNotify(x, y, z, 2, 2);
                break;
            }
            case 1: {
                world.setBlockMetadataWithNotify(x, y, z, 5, 2);
                break;
            }
            case 2: {
                world.setBlockMetadataWithNotify(x, y, z, 3, 2);
                break;
            }
            case 3: {
                world.setBlockMetadataWithNotify(x, y, z, 4, 2);
            }
        }
        if (!world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntityBeartrap tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBeartrap.class);
            if (tile != null) {
                tile.owner = player.getGameProfile();
                tile.sprung = true;
                tile.markBlockForUpdate(false);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.silvered) {
            return new ArrayList<ItemStack>();
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (!world.isRemote && entity instanceof EntityLivingBase) {
            AxisAlignedBB trapBounds;
            EntityLivingBase living = (EntityLivingBase)entity;
            TileEntityBeartrap tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBeartrap.class);
            if (!(tile == null || tile.sprung || world.getTotalWorldTime() <= tile.setTime + 20L || this.silvered && !CreatureUtil.isWerewolf(entity, false) || !(trapBounds = AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY), (double)((double)z + this.maxZ))).intersectsWith(entity.boundingBox) || this.silvered && !tile.tryTrapWolf(living))) {
                boolean isCreative;
                boolean bl = isCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.isCreativeMode;
                if (!isCreative) {
                    living.addPotionEffect(new PotionEffect(Witchery.Potions.PARALYSED.id, TimeUtil.secsToTicks(30), 2, true));
                }
                living.attackEntityFrom(DamageSource.anvil, 4.0f);
                ParticleEffect.REDDUST.send(SoundEffect.WITCHERY_RANDOM_MANTRAP, world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 0.25, 0.5, 16);
                tile.sprung = true;
                tile.markBlockForUpdate(true);
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityBeartrap tile;
        if (!world.isRemote && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBeartrap.class)) != null) {
            SoundEffect.WITCHERY_RANDOM_CLICK.playAtPlayer(world, player);
            tile.sprung = !tile.sprung;
            if (!tile.sprung) {
                tile.setTime = world.getTotalWorldTime();
            }
            tile.markBlockForUpdate(false);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean checkForHiddenTrap(EntityPlayer player, MovingObjectPosition mop) {
        TileEntityBeartrap tile;
        if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && player.worldObj.getBlock(mop.blockX, mop.blockY, mop.blockZ) == Witchery.Blocks.BEARTRAP && (tile = BlockUtil.getTileEntity((IBlockAccess)player.worldObj, mop.blockX, mop.blockY, mop.blockZ, TileEntityBeartrap.class)) != null) {
            return !tile.isVisibleTo(player);
        }
        return false;
    }

    public static class TileEntityBeartrap
    extends TileEntityBase {
        private final boolean silvered;
        private GameProfile owner;
        private boolean sprung = true;
        private long setTime = 0L;
        private long startTime = 0L;
        private UUID spawnedWolfID = null;
        private static final int MIN_LURE_TIME = TimeUtil.minsToTicks(1);
        private static final int LURE_EXTRA = TimeUtil.minsToTicks(1);

        public TileEntityBeartrap() {
            this.silvered = false;
        }

        public TileEntityBeartrap(boolean silvered) {
            this.silvered = silvered;
        }

        public boolean tryTrapWolf(EntityLivingBase living) {
            if (this.silvered && living instanceof EntityWolfman) {
                EntityWolfman wolf = (EntityWolfman)living;
                if (this.spawnedWolfID != null && wolf != null && wolf.getPersistentID().equals(this.spawnedWolfID)) {
                    SoundEffect.WITCHERY_MOB_WOLFMAN_LORD.playAt(this, 1.0f);
                    wolf.setInfectious();
                    return true;
                }
            }
            return false;
        }

        public boolean isSprung() {
            return this.sprung;
        }

        public boolean canUpdate() {
            return this.silvered;
        }

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote && this.silvered && !this.sprung && this.spawnedWolfID == null && TimeUtil.secondsElapsed(10, this.ticks)) {
                if (this.baitFound() && CreatureUtil.isFullMoon(this.worldObj)) {
                    long time = this.worldObj.getTotalWorldTime();
                    if (this.startTime > 0L) {
                        EntityCreature creature;
                        long activateTime = this.startTime;
                        if (time > activateTime && CreatureUtil.isFullMoon(this.worldObj) && (creature = InfusionInfernal.spawnCreature(this.worldObj, EntityWolfman.class, this.xCoord, this.yCoord, this.zCoord, null, 16, 32, ParticleEffect.SMOKE, SoundEffect.WITCHERY_MOB_WOLFMAN_TALK)) != null) {
                            creature.func_110163_bv();
                            this.spawnedWolfID = creature.getPersistentID();
                        }
                    } else {
                        this.startTime = time;
                    }
                } else {
                    this.startTime = 0L;
                }
            }
        }

        private boolean baitFound() {
            double R = 8.0;
            double RSQ = 64.0;
            boolean foundSheep = false;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(0.5 + (double)this.xCoord - 8.0), (double)(0.5 + (double)this.yCoord - 8.0), (double)(0.5 + (double)this.zCoord - 8.0), (double)(0.5 + (double)this.xCoord + 8.0), (double)(0.5 + (double)this.yCoord + 8.0), (double)(0.5 + (double)this.zCoord + 8.0));
            List sheep = this.worldObj.getEntitiesWithinAABB(EntitySheep.class, bounds);
            for (EntitySheep aSheep : sheep) {
                if (!(aSheep.getDistanceSq(0.5 + (double)this.xCoord, 0.5 + (double)this.yCoord, 0.5 + (double)this.zCoord) <= 64.0) || !aSheep.getLeashed()) continue;
                foundSheep = true;
                break;
            }
            boolean wolfaltar = this.worldObj.getBlock(this.xCoord + 1, this.yCoord, this.zCoord) == Witchery.Blocks.WOLF_ALTAR || this.worldObj.getBlock(this.xCoord - 1, this.yCoord, this.zCoord) == Witchery.Blocks.WOLF_ALTAR || this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord + 1) == Witchery.Blocks.WOLF_ALTAR || this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord - 1) == Witchery.Blocks.WOLF_ALTAR;
            return wolfaltar && foundSheep;
        }

        public boolean isVisibleTo(EntityPlayer player) {
            if (this.sprung || this.owner == null || this.silvered) {
                return true;
            }
            if (player == null) {
                return false;
            }
            return player.getGameProfile().equals((Object)this.owner);
        }

        public void writeToNBT(NBTTagCompound nbtRoot) {
            super.writeToNBT(nbtRoot);
            nbtRoot.setBoolean("Sprung", this.sprung);
            nbtRoot.setLong("WolftrapStart", this.startTime);
            if (this.spawnedWolfID != null) {
                nbtRoot.setLong("WolfLeast", this.spawnedWolfID.getLeastSignificantBits());
                nbtRoot.setLong("WolfMost", this.spawnedWolfID.getMostSignificantBits());
            }
            if (this.owner != null) {
                NBTTagCompound nbtPlayer = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)nbtPlayer, (GameProfile)this.owner);
                nbtRoot.setTag("Owner", (NBTBase)nbtPlayer);
            }
        }

        public void readFromNBT(NBTTagCompound nbtRoot) {
            super.readFromNBT(nbtRoot);
            this.sprung = nbtRoot.getBoolean("Sprung");
            this.startTime = nbtRoot.getLong("WolftrapStart");
            this.owner = nbtRoot.hasKey("Owner", 10) ? NBTUtil.func_152459_a((NBTTagCompound)nbtRoot.getCompoundTag("Owner")) : null;
            this.spawnedWolfID = nbtRoot.hasKey("WolfLeast") && nbtRoot.hasKey("WolfMost") ? new UUID(nbtRoot.getLong("WolfMost"), nbtRoot.getLong("WolfLeast")) : null;
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }
}

