/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.BlockGrassper;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.entity.EntityCovenWitch;
import com.emoniph.witchery.ritual.Circle;
import com.emoniph.witchery.ritual.RiteRegistry;
import com.emoniph.witchery.ritual.RitualStep;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.Log;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCircle
extends BlockBaseContainer {
    public BlockCircle() {
        super(Material.vine, TileEntityCircle.class);
        this.registerWithCreateTab = false;
        this.setHardness(3.0f);
        this.setResistance(1000.0f);
        float f1 = 0.015625f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        return this.blockIcon;
    }

    public void onBlockClicked(World world, int posX, int posY, int posZ, EntityPlayer player) {
        ItemStack itemstack;
        if (!world.isRemote && (itemstack = player.getHeldItem()) != null && (Witchery.Items.GENERIC.itemBroom.isMatch(itemstack) || Witchery.Items.GENERIC.itemBroomEnchanted.isMatch(itemstack))) {
            world.func_147480_a(posX, posY, posZ, false);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(Witchery.Items.CHALK_GOLDEN);
    }

    public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, Block par5) {
        if (this.func_111046_k(par1World, par2, par3, par4)) {
            boolean flag = par1World.isBlockIndirectlyGettingPowered(par2, par3, par4);
            TileEntityCircle tileCircle = BlockUtil.getTileEntity((IBlockAccess)par1World, par2, par3, par4, TileEntityCircle.class);
            if (tileCircle != null && tileCircle.previousRedstoneState != flag) {
                if (flag) {
                    this.activateBlock(par1World, par2, par3, par4, null, false);
                }
                tileCircle.previousRedstoneState = flag;
            }
        }
    }

    private boolean func_111046_k(World par1World, int par2, int par3, int par4) {
        if (!this.canBlockStay(par1World, par2, par3, par4)) {
            par1World.setBlockToAir(par2, par3, par4);
            return false;
        }
        return true;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        Material material = world.getBlock(x, y - 1, z).getMaterial();
        return !world.isAirBlock(x, y - 1, z) && material != null && material.isOpaque() && material.isSolid();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return par5 == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 1) {
            double d0 = (float)x + 0.4f + rand.nextFloat() * 0.2f;
            double d1 = (float)y + 0.1f + rand.nextFloat() * 0.3f;
            double d2 = (float)z + 0.4f + rand.nextFloat() * 0.2f;
            world.spawnParticle(ParticleEffect.REDDUST.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem();
        this.activateBlock(world, x, y, z, player, stack != null && Witchery.Items.GENERIC.itemSeerStone.isMatch(stack));
        return true;
    }

    private void activateBlock(World world, int posX, int posY, int posZ, EntityPlayer player, boolean summonCoven) {
        TileEntityCircle tileEntity = BlockUtil.getTileEntity((IBlockAccess)world, posX, posY, posZ, TileEntityCircle.class);
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.isRitualActive()) {
            tileEntity.deactivate();
            return;
        }
        if (world.isRemote) {
            return;
        }
        if (PowerSources.instance().isAreaNulled(world, posX, posY, posZ) || world.provider.dimensionId == Config.instance().dimensionDreamID) {
            ChatUtil.sendTranslated(EnumChatFormatting.RED, (ICommandSender)player, "witchery.rite.nullfield", new Object[0]);
            SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            return;
        }
        Circle a = new Circle(16);
        Circle b = new Circle(28);
        Circle c = new Circle(40);
        Circle _ = new Circle(0);
        Circle[][] PATTERN = new Circle[][]{{_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _}, {_, _, _, _, _, c, c, c, c, c, c, c, _, _, _, _, _}, {_, _, _, _, c, _, _, _, _, _, _, _, c, _, _, _, _}, {_, _, _, c, _, _, b, b, b, b, b, _, _, c, _, _, _}, {_, _, c, _, _, b, _, _, _, _, _, b, _, _, c, _, _}, {_, c, _, _, b, _, _, a, a, a, _, _, b, _, _, c, _}, {_, c, _, b, _, _, a, _, _, _, a, _, _, b, _, c, _}, {_, c, _, b, _, a, _, _, _, _, _, a, _, b, _, c, _}, {_, c, _, b, _, a, _, _, _, _, _, a, _, b, _, c, _}, {_, c, _, b, _, a, _, _, _, _, _, a, _, b, _, c, _}, {_, c, _, b, _, _, a, _, _, _, a, _, _, b, _, c, _}, {_, c, _, _, b, _, _, a, a, a, _, _, b, _, _, c, _}, {_, _, c, _, _, b, _, _, _, _, _, b, _, _, c, _, _}, {_, _, _, c, _, _, b, b, b, b, b, _, _, c, _, _, _}, {_, _, _, _, c, _, _, _, _, _, _, _, c, _, _, _, _}, {_, _, _, _, _, c, c, c, c, c, c, c, _, _, _, _, _}, {_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _}};
        int offsetZ = (PATTERN.length - 1) / 2;
        for (int z = 0; z < PATTERN.length - 1; ++z) {
            int worldZ = posZ - offsetZ + z;
            int offsetX = (PATTERN[z].length - 1) / 2;
            for (int x = 0; x < PATTERN[z].length; ++x) {
                int worldX = posX - offsetX + x;
                PATTERN[PATTERN.length - 1 - z][x].addGlyph(world, worldX, posY, worldZ);
            }
        }
        boolean isDaytime = world.isDaytime();
        boolean isRainPossible = world.getBiomeGenForCoords(posX, posZ).canSpawnLightningBolt();
        boolean isRaining = world.isRaining() && isRainPossible;
        boolean isThundering = world.isThundering();
        int maxRadius = PATTERN.length / 2;
        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(posX - maxRadius), (double)posY, (double)(posZ - maxRadius), (double)(posX + maxRadius), (double)(posY + 1), (double)(posZ + maxRadius));
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object obj : world.getEntitiesWithinAABB(Entity.class, bounds)) {
            Entity item = (Entity)obj;
            entities.add(item);
        }
        ArrayList<ItemStack> grassperStacks = new ArrayList<ItemStack>();
        int radius = 5;
        for (int x = posX - 5; x <= posX + 5; ++x) {
            for (int z = posZ - 5; z <= posZ + 5; ++z) {
                BlockGrassper.TileEntityGrassper grassper;
                ItemStack stack;
                TileEntity tile;
                Block block = world.getBlock(x, posY, z);
                if (block != Witchery.Blocks.GRASSPER || (tile = world.getTileEntity(x, posY, z)) == null || !(tile instanceof BlockGrassper.TileEntityGrassper) || (stack = (grassper = (BlockGrassper.TileEntityGrassper)tile).getStackInSlot(0)) == null) continue;
                grassperStacks.add(stack);
            }
        }
        Circle[] circles = new Circle[]{a, b, c};
        boolean ritualFound = false;
        int covenSize = summonCoven ? EntityCovenWitch.getCovenSize(player) : 0;
        for (RiteRegistry.Ritual ritual : RiteRegistry.instance().getRituals()) {
            if (!ritual.isMatch(world, posX, posY, posZ, circles, entities, grassperStacks, isDaytime, isRaining, isThundering)) continue;
            tileEntity.queueRitual(ritual, bounds, player, covenSize, summonCoven);
            summonCoven = false;
            ritualFound = true;
        }
        if (!ritualFound && !world.isRemote) {
            RiteRegistry.RiteError("witchery.rite.unknownritual", player, world);
            SoundEffect.NOTE_SNARE.playAt(world, posX, posY, posZ);
        }
    }

    public static class TileEntityCircle
    extends TileEntityBase {
        public boolean previousRedstoneState;
        private final ArrayList<ActivatedRitual> activeRituals = new ArrayList();
        private final ArrayList<ActivatedRitual> upkeepRituals = new ArrayList();
        private boolean abortNext = false;

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            byte[] ritualIDs = new byte[this.upkeepRituals.size()];
            byte[] stages = new byte[this.upkeepRituals.size()];
            byte[] covenSizes = new byte[this.upkeepRituals.size()];
            NBTTagList nbtList = new NBTTagList();
            NBTTagList nbtLocationList = new NBTTagList();
            for (int i = 0; i < this.upkeepRituals.size(); ++i) {
                ritualIDs[i] = this.upkeepRituals.get(i).ritual.getRitualID();
                stages[i] = (byte)this.upkeepRituals.get(i).getCurrentStage();
                covenSizes[i] = (byte)this.upkeepRituals.get((int)i).covenSize;
                nbtList.appendTag((NBTBase)new NBTTagString(this.upkeepRituals.get(i).getInitiatingPlayerName()));
                nbtLocationList.appendTag((NBTBase)this.upkeepRituals.get(i).getLocationTag());
            }
            nbtTag.setByteArray("Rituals", ritualIDs);
            nbtTag.setByteArray("RitualStages", stages);
            nbtTag.setTag("Initiators", (NBTBase)nbtList);
            nbtTag.setTag("Locations", (NBTBase)nbtLocationList);
            nbtTag.setByteArray("RitualCovens", covenSizes);
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            super.readFromNBT(nbtTag);
            if (nbtTag.hasKey("Rituals") && nbtTag.hasKey("RitualStages")) {
                byte[] stages = nbtTag.getByteArray("RitualStages");
                byte[] ritualIDs = nbtTag.getByteArray("Rituals");
                Coord[] locations = new Coord[stages.length];
                if (nbtTag.hasKey("Locations")) {
                    NBTTagList list = nbtTag.getTagList("Locations", 10);
                    for (int i = 0; i < Math.min(list.tagCount(), locations.length); ++i) {
                        NBTTagCompound nbtListItem = list.getCompoundTagAt(i);
                        locations[i] = Coord.fromTagNBT(nbtListItem);
                    }
                }
                String[] initators = new String[stages.length];
                if (nbtTag.hasKey("Initiators")) {
                    NBTTagList list = nbtTag.getTagList("Initiators", 8);
                    for (int i = 0; i < Math.min(list.tagCount(), initators.length); ++i) {
                        String nbtListItem = list.getStringTagAt(i);
                        initators[i] = nbtListItem != null && !nbtListItem.isEmpty() ? nbtListItem : null;
                    }
                }
                byte[] covenSizes = nbtTag.hasKey("RitualCovens") ? nbtTag.getByteArray("RitualCovens") : null;
                for (int i = 0; i < ritualIDs.length; ++i) {
                    RiteRegistry.Ritual ritual = RiteRegistry.instance().getRitual(ritualIDs[i]);
                    if (ritual == null) continue;
                    ArrayList<RitualStep> ritualSteps = new ArrayList<RitualStep>();
                    ritual.addRiteSteps(ritualSteps, stages[i]);
                    if (ritualSteps.isEmpty()) continue;
                    ActivatedRitual activatedRitual = new ActivatedRitual(ritual, ritualSteps, initators[i], covenSizes != null ? covenSizes[i] : (byte)0);
                    activatedRitual.setLocation(locations[i]);
                    this.upkeepRituals.add(activatedRitual);
                }
            }
        }

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (!this.worldObj.isRemote) {
                if (!this.upkeepRituals.isEmpty()) {
                    for (ActivatedRitual upkeepRitual : this.upkeepRituals) {
                        RitualStep.Result result = ((RitualStep)upkeepRitual.steps.get(0)).run(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.ticks, upkeepRitual);
                        if (result != RitualStep.Result.UPKEEP && Config.instance().traceRites()) {
                            Log.instance().traceRite(String.format(" - Upkeep ritual=%s, step=%s, result=%s", upkeepRitual.ritual.getUnlocalizedName(), ((RitualStep)upkeepRitual.steps.get(0)).toString(), result.toString()));
                        }
                        switch (result) {
                            case COMPLETED: {
                                upkeepRitual.steps.clear();
                                break;
                            }
                            case ABORTED: 
                            case ABORTED_REFUND: {
                                upkeepRitual.steps.clear();
                                SoundEffect.NOTE_SNARE.playAt(this);
                                break;
                            }
                        }
                    }
                    for (int i = this.upkeepRituals.size() - 1; i >= 0; --i) {
                        if (!this.upkeepRituals.get(i).steps.isEmpty()) continue;
                        this.upkeepRituals.remove(i);
                    }
                }
                if (!this.activeRituals.isEmpty()) {
                    ActivatedRitual ritual = this.activeRituals.get(0);
                    RitualStep.Result result = ((RitualStep)ritual.steps.get(0)).run(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.ticks, ritual);
                    ritual.postProcess(this.worldObj);
                    if (this.abortNext) {
                        this.abortNext = false;
                        result = RitualStep.Result.ABORTED_REFUND;
                        this.activeRituals.clear();
                    }
                    if (result != RitualStep.Result.STARTING && Config.instance().traceRites()) {
                        Log.instance().traceRite(String.format("Active ritual=%s, step=%s, result=%s", ritual.ritual.getUnlocalizedName(), ((RitualStep)ritual.steps.get(0)).toString(), result.toString()));
                    }
                    switch (result) {
                        case UPKEEP: {
                            if (this.activeRituals.size() > 0) {
                                this.activeRituals.remove(0);
                            }
                            this.upkeepRituals.add(ritual);
                            break;
                        }
                        case COMPLETED: {
                            if (ritual.steps.size() > 0) {
                                ritual.steps.remove(0);
                            }
                            if (!ritual.steps.isEmpty()) break;
                            this.activeRituals.remove(0);
                            break;
                        }
                        case ABORTED: 
                        case ABORTED_REFUND: {
                            if (this.activeRituals.size() > 0) {
                                this.activeRituals.remove(0);
                            }
                            if (this.worldObj.isRemote) break;
                            SoundEffect.NOTE_SNARE.playAt(this);
                            if (result != RitualStep.Result.ABORTED_REFUND) break;
                            for (RitualStep.SacrificedItem sacrificedItem : ritual.sacrificedItems) {
                                this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, 0.5 + (double)sacrificedItem.location.x, 0.5 + (double)sacrificedItem.location.y, 0.5 + (double)sacrificedItem.location.z, sacrificedItem.itemstack));
                            }
                            break;
                        }
                    }
                }
                if (!this.isRitualActive() && this.getBlockMetadata() != 0) {
                    this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 0, 3);
                }
            }
        }

        public void deactivate() {
            if (!this.worldObj.isRemote) {
                if (this.activeRituals.size() > 0) {
                    this.abortNext = true;
                }
                this.upkeepRituals.clear();
                this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 0, 3);
                SoundEffect.NOTE_SNARE.playAt(this);
            }
        }

        public boolean isRitualActive() {
            return !this.activeRituals.isEmpty() || !this.upkeepRituals.isEmpty();
        }

        public void queueRitual(RiteRegistry.Ritual ritual, AxisAlignedBB bounds, EntityPlayer player, int covenSize, boolean summonCoven) {
            ArrayList<RitualStep> ritualSteps = new ArrayList<RitualStep>();
            if (summonCoven) {
                EntityCovenWitch.summonCoven(ritualSteps, player.worldObj, player, new int[][]{{this.xCoord - 2, this.yCoord, this.zCoord - 2}, {this.xCoord + 2, this.yCoord, this.zCoord - 2}, {this.xCoord - 2, this.yCoord, this.zCoord + 2}, {this.xCoord + 2, this.yCoord, this.zCoord + 2}, {this.xCoord, this.yCoord, this.zCoord + 3}, {this.xCoord, this.yCoord, this.zCoord - 3}});
            }
            ritual.addSteps(ritualSteps, bounds);
            if (ritualSteps.size() > 0 && !this.worldObj.isRemote) {
                this.activeRituals.add(new ActivatedRitual(ritual, ritualSteps, player != null ? player.getCommandSenderName() : null, covenSize));
                this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 1, 3);
            }
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }

        public static class ActivatedRitual {
            private final RiteRegistry.Ritual ritual;
            private final ArrayList<RitualStep> steps;
            public final String playerName;
            public final ArrayList<RitualStep.SacrificedItem> sacrificedItems = new ArrayList();
            public final int covenSize;
            private Coord coord;

            private ActivatedRitual(RiteRegistry.Ritual ritual, ArrayList<RitualStep> steps, String playerName, int covenSize) {
                this.ritual = ritual;
                this.steps = steps;
                this.playerName = playerName;
                this.covenSize = covenSize;
            }

            public Coord getLocation() {
                return this.coord;
            }

            public NBTTagCompound getLocationTag() {
                return this.coord != null ? this.coord.toTagNBT() : new NBTTagCompound();
            }

            public void setLocation(Coord coord) {
                this.coord = coord;
            }

            public String getInitiatingPlayerName() {
                return this.playerName != null ? this.playerName : "";
            }

            public EntityPlayer getInitiatingPlayer(World world) {
                return world.getPlayerEntityByName(this.getInitiatingPlayerName());
            }

            public void postProcess(World world) {
                for (int i = 0; i < this.sacrificedItems.size(); ++i) {
                    RitualStep.SacrificedItem sacrificedItem = this.sacrificedItems.get(i);
                    if (sacrificedItem == null || sacrificedItem.itemstack == null) continue;
                    if (!this.ritual.isConsumeAttunedStoneCharged() && Witchery.Items.GENERIC.itemAttunedStoneCharged.isMatch(sacrificedItem.itemstack)) {
                        world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)sacrificedItem.location.x, 0.5 + (double)sacrificedItem.location.y, 0.5 + (double)sacrificedItem.location.z, Witchery.Items.GENERIC.itemAttunedStone.createStack()));
                        this.sacrificedItems.remove(i);
                        break;
                    }
                    if (sacrificedItem.itemstack.getItem() == Witchery.Items.ARTHANA) {
                        world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)sacrificedItem.location.x, 0.5 + (double)sacrificedItem.location.y, 0.5 + (double)sacrificedItem.location.z, sacrificedItem.itemstack));
                        this.sacrificedItems.remove(i);
                        break;
                    }
                    if (sacrificedItem.itemstack.getItem() == Witchery.Items.BOLINE) {
                        world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)sacrificedItem.location.x, 0.5 + (double)sacrificedItem.location.y, 0.5 + (double)sacrificedItem.location.z, sacrificedItem.itemstack));
                        this.sacrificedItems.remove(i);
                        break;
                    }
                    if (this.ritual.isConsumeNecroStone() || !Witchery.Items.GENERIC.itemNecroStone.isMatch(sacrificedItem.itemstack)) continue;
                    world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)sacrificedItem.location.x, 0.5 + (double)sacrificedItem.location.y, 0.5 + (double)sacrificedItem.location.z, sacrificedItem.itemstack));
                    this.sacrificedItems.remove(i);
                    break;
                }
            }

            public int getCurrentStage() {
                if (!this.steps.isEmpty()) {
                    return this.steps.get(0).getCurrentStage();
                }
                return 0;
            }
        }
    }
}

