/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.blocks.BlockBaseBush;
import com.emoniph.witchery.item.ItemPolynesiaCharm;
import com.emoniph.witchery.util.MultiItemBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockCritterSnare
extends BlockBaseBush {
    private static final String[] CAUGHT_TYPES = new String[]{"empty", "bat", "silverfish", "slime", "magmacube"};
    private static final String[] CAUGHT_TYPES_SOUNDS = new String[]{"", "mob.bat.idle", "mob.silverfish.say", "mob.slime.small", "mob.magmacube.small"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] critterIcons;

    public BlockCritterSnare() {
        super(Material.plants, ClassItemBlock.class);
        this.setStepSound(soundTypeGrass);
        float f = 0.45f;
        this.setBlockBounds(0.050000012f, 0.0f, 0.050000012f, 0.95f, 1.0f, 0.95f);
    }

    public void onEntityCollidedWithBlock(World world, int posX, int posY, int posZ, Entity entity) {
        int meta = world.getBlockMetadata(posX, posY, posZ);
        if (meta == 0 && !world.isRemote && entity != null && entity.isEntityAlive()) {
            if (entity instanceof EntityBat) {
                boolean hasStock = ItemPolynesiaCharm.hasStockInventory((EntityLiving)((EntityBat)entity));
                world.setBlockMetadataWithNotify(posX, posY, posZ, hasStock ? 9 : 1, 3);
                entity.setDead();
            } else if (entity instanceof EntitySilverfish) {
                world.setBlockMetadataWithNotify(posX, posY, posZ, 2, 3);
                entity.setDead();
            } else if (entity instanceof EntityMagmaCube && ((EntityMagmaCube)entity).getSlimeSize() == 1) {
                world.setBlockMetadataWithNotify(posX, posY, posZ, 4, 3);
                entity.setDead();
            } else if (entity instanceof EntitySlime && ((EntitySlime)entity).getSlimeSize() == 1) {
                world.setBlockMetadataWithNotify(posX, posY, posZ, 3, 3);
                entity.setDead();
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        int meta = world.getBlockMetadata(x, y, z);
        if (!world.isRemote && meta > 0 && player.isSneaking()) {
            world.setBlockMetadataWithNotify(x, y, z, 0, 3);
            int tries = 0;
            switch (this.getCritterFromMeta(meta)) {
                case 1: {
                    EntityBat bat = new EntityBat(world);
                    bat.setLocationAndAngles(0.5 + (double)x, 1.5 + (double)y, 0.5 + (double)z, 0.0f, 0.0f);
                    if ((meta & 8) == 8) {
                        ItemPolynesiaCharm.setEmptyStockInventory(world, (EntityLiving)bat);
                    }
                    world.spawnEntityInWorld((Entity)bat);
                    break;
                }
                case 2: {
                    EntitySilverfish silverfish = new EntitySilverfish(world);
                    silverfish.setLocationAndAngles(player.posX < (double)x ? (double)x - 0.5 : (double)x + 1.5, player.posY + 0.5, player.posZ < (double)z ? (double)z - 0.5 : (double)z + 1.5, 0.0f, 0.0f);
                    world.spawnEntityInWorld((Entity)silverfish);
                    break;
                }
                case 3: {
                    EntitySlime slime = null;
                    tries = 20;
                    while ((slime = new EntitySlime(world)).getSlimeSize() != 1 && --tries > 0) {
                    }
                    if (tries > 0) {
                        slime.setLocationAndAngles(player.posX < (double)x ? (double)x - 0.5 : (double)x + 1.5, player.posY + 0.5, player.posZ < (double)z ? (double)z - 0.5 : (double)z + 1.5, 0.0f, 0.0f);
                        world.spawnEntityInWorld((Entity)slime);
                        break;
                    }
                    world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 1.5 + (double)y, 0.5 + (double)z, new ItemStack(Items.slime_ball)));
                    break;
                }
                case 4: {
                    EntityMagmaCube cube = null;
                    tries = 20;
                    while ((cube = new EntityMagmaCube(world)).getSlimeSize() != 1 && --tries > 0) {
                    }
                    if (tries > 0) {
                        cube.setLocationAndAngles(player.posX < (double)x ? (double)x - 0.5 : (double)x + 1.5, player.posY + 0.5, player.posZ < (double)z ? (double)z - 0.5 : (double)z + 1.5, 0.0f, 0.0f);
                        world.spawnEntityInWorld((Entity)cube);
                        break;
                    }
                    world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 1.5 + (double)y, 0.5 + (double)z, new ItemStack(Items.magma_cream)));
                }
            }
        }
        return true;
    }

    private int getCritterFromMeta(int meta) {
        int critter = meta & 7;
        if (critter < 0 || critter >= CAUGHT_TYPES.length) {
            critter = 0;
        }
        return critter;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        int critterType = this.getCritterFromMeta(meta);
        return this.critterIcons[critterType];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.critterIcons = new IIcon[CAUGHT_TYPES.length];
        for (int i = 0; i < CAUGHT_TYPES.length; ++i) {
            this.critterIcons[i] = iconRegister.registerIcon(this.getTextureName() + "_" + CAUGHT_TYPES[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int meta;
        int critterType;
        if (rand.nextInt(24) == 0 && (critterType = this.getCritterFromMeta(meta = world.getBlockMetadata(x, y, z))) > 0 && critterType < CAUGHT_TYPES_SOUNDS.length) {
            String sound = CAUGHT_TYPES_SOUNDS[critterType];
            world.playSound((double)x, (double)y, (double)z, sound, 0.5f, 0.4f / ((float)world.rand.nextDouble() * 0.4f + 0.8f), false);
        }
    }

    public Item getItemDropped(int par1, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this);
    }

    public int damageDropped(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
    }

    protected ItemStack createStackedBlock(int par1) {
        return new ItemStack((Block)this, 1, par1);
    }

    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return super.canPlaceBlockAt(par1World, par2, par3, par4) && this.canBlockStay(par1World, par2, par3, par4);
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block != null && block.isOpaqueCube();
    }

    public boolean canBlockStay(World world, int posX, int posY, int posZ) {
        Material material = world.getBlock(posX, posY - 1, posZ).getMaterial();
        return material != null && material.isSolid();
    }

    public void harvestBlock(World par3World, EntityPlayer player, int par4, int par5, int par6, int damageValue) {
        super.harvestBlock(par3World, player, par4, par5, par6, damageValue);
    }

    public static class ClassItemBlock
    extends MultiItemBlock {
        public ClassItemBlock(Block block) {
            super(block);
        }

        @Override
        protected String[] getNames() {
            return CAUGHT_TYPES;
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIconFromDamage(int par1) {
            return this.field_150939_a.getIcon(0, par1);
        }
    }
}

