/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.util.ParticleEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDemonHeart
extends BlockBaseContainer {
    public BlockDemonHeart() {
        super(Material.ground, TileEntityDemonHeart.class);
        this.registerWithCreateTab = false;
        this.setLightLevel(0.2f);
        this.setHardness(1.0f);
        this.setStepSound(soundTypeGravel);
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.8f, 0.75f);
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4, 2);
        }
    }

    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileEntityDemonHeart();
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    public Item getItemDropped(int par1, Random rand, int fortune) {
        return Witchery.Items.GENERIC;
    }

    public int damageDropped(int par1) {
        return Witchery.Items.GENERIC.itemDemonHeart.damageValue;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return Witchery.Items.GENERIC.itemDemonHeart.createStack();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        double yMid = (double)y + 0.8;
        double mid1 = 0.35 + 0.3 * rand.nextDouble();
        double mid2 = 0.35 + 0.3 * rand.nextDouble();
        if (rand.nextInt(10) == 0) {
            world.spawnParticle(ParticleEffect.FLAME.toString(), (double)x + mid1, yMid, (double)z + mid2, 0.0, 0.0, 0.0);
            world.spawnParticle(ParticleEffect.SMOKE.toString(), (double)x + mid1, yMid, (double)z + mid2, 0.0, 0.0, 0.0);
        }
    }

    public static class TileEntityDemonHeart
    extends TileEntityBase {
        public long totalTicks() {
            return this.ticks;
        }

        @Override
        public void updateEntity() {
            super.updateEntity();
            if (this.worldObj.isRemote && this.ticks % 25L == 0L) {
                this.worldObj.playSound(0.5 + (double)this.xCoord, 0.5 + (double)this.yCoord, 0.5 + (double)this.zCoord, "witchery:random.heartbeat", 0.8f, 1.0f, false);
            }
        }
    }
}

