/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockAltar;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.TileEntityBase;
import com.emoniph.witchery.common.IPowerSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.crafting.DistilleryRecipes;
import com.emoniph.witchery.util.BlockSide;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SlotClayJar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDistillery
extends BlockBaseContainer {
    private final Random furnaceRand = new Random();
    private final boolean isActive;
    private static boolean keepFurnaceInventory;

    public BlockDistillery(boolean burning) {
        super(Material.iron, TileEntityDistillery.class);
        this.registerTileEntity = !burning;
        this.registerWithCreateTab = !burning;
        this.isActive = burning;
        this.setHardness(3.5f);
        this.setStepSound(soundTypeMetal);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (burning) {
            this.setLightLevel(0.4f);
        }
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon(this.getTextureName());
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.getItemFromBlock((Block)Witchery.Blocks.DISTILLERY_IDLE);
    }

    public void onBlockAdded(World par1World, int par2, int par3, int par4) {
        super.onBlockAdded(par1World, par2, par3, par4);
        BlockUtil.setBlockDefaultDirection(par1World, par2, par3, par4);
    }

    public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.isRemote) {
            return true;
        }
        TileEntityDistillery tileentityfurnace = (TileEntityDistillery)par1World.getTileEntity(par2, par3, par4);
        if (tileentityfurnace != null) {
            par5EntityPlayer.openGui((Object)Witchery.instance, 3, par1World, par2, par3, par4);
        }
        return true;
    }

    public static void updateDistilleryBlockState(boolean par0, World par1World, int par2, int par3, int par4) {
        int l = par1World.getBlockMetadata(par2, par3, par4);
        TileEntity tileentity = par1World.getTileEntity(par2, par3, par4);
        keepFurnaceInventory = true;
        if (par0) {
            par1World.setBlock(par2, par3, par4, Witchery.Blocks.DISTILLERY_BURNING);
        } else {
            par1World.setBlock(par2, par3, par4, Witchery.Blocks.DISTILLERY_IDLE);
        }
        keepFurnaceInventory = false;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, l, 2);
        if (tileentity != null) {
            tileentity.validate();
            par1World.setTileEntity(par2, par3, par4, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (this.isActive) {
            double d0 = (float)par2 + 0.4f + par5Random.nextFloat() * 0.2f;
            double d1 = (float)par3 + 1.0f + par5Random.nextFloat() * 0.3f;
            double d2 = (float)par4 + 0.4f + par5Random.nextFloat() * 0.2f;
            par1World.spawnParticle(ParticleEffect.INSTANT_SPELL.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4, 2);
        }
    }

    public void breakBlock(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        TileEntityDistillery tileentityfurnace;
        if (!keepFurnaceInventory && (tileentityfurnace = (TileEntityDistillery)par1World.getTileEntity(par2, par3, par4)) != null) {
            for (int j1 = 0; j1 < tileentityfurnace.getSizeInventory(); ++j1) {
                ItemStack itemstack = tileentityfurnace.getStackInSlot(j1);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int k1 = this.furnaceRand.nextInt(21) + 10;
                    if (k1 > itemstack.stackSize) {
                        k1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)par2 + f), (double)((float)par3 + f1), (double)((float)par4 + f2), new ItemStack(itemstack.getItem(), k1, itemstack.getItemDamage()));
                    if (itemstack.hasTagCompound()) {
                        entityitem.getEntityItem().setTagCompound((NBTTagCompound)itemstack.getTagCompound().copy());
                    }
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.motionY = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.furnaceRand.nextGaussian() * f3;
                    par1World.spawnEntityInWorld((Entity)entityitem);
                }
            }
            par1World.func_147453_f(par2, par3, par4, par5);
        }
        super.breakBlock(par1World, par2, par3, par4, par5, par6);
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World par1World, int par2, int par3, int par4, int par5) {
        return Container.calcRedstoneFromInventory((IInventory)((IInventory)par1World.getTileEntity(par2, par3, par4)));
    }

    public Item getItem(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return Item.getItemFromBlock((Block)Witchery.Blocks.DISTILLERY_IDLE);
    }

    public static class ContainerDistillery
    extends Container {
        private TileEntityDistillery furnace;
        private int lastCookTime;
        private int lastPowerLevel;

        public ContainerDistillery(InventoryPlayer par1InventoryPlayer, TileEntityDistillery par2TileEntityFurnace) {
            int i;
            this.furnace = par2TileEntityFurnace;
            this.addSlotToContainer(new Slot((IInventory)par2TileEntityFurnace, 0, 48, 16));
            this.addSlotToContainer(new Slot((IInventory)par2TileEntityFurnace, 1, 48, 34));
            this.addSlotToContainer(new SlotClayJar((IInventory)par2TileEntityFurnace, 2, 48, 54));
            this.addSlotToContainer((Slot)new SlotFurnace(par1InventoryPlayer.player, (IInventory)par2TileEntityFurnace, 3, 110, 16));
            this.addSlotToContainer((Slot)new SlotFurnace(par1InventoryPlayer.player, (IInventory)par2TileEntityFurnace, 4, 128, 16));
            this.addSlotToContainer((Slot)new SlotFurnace(par1InventoryPlayer.player, (IInventory)par2TileEntityFurnace, 5, 110, 34));
            this.addSlotToContainer((Slot)new SlotFurnace(par1InventoryPlayer.player, (IInventory)par2TileEntityFurnace, 6, 128, 34));
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.addSlotToContainer(new Slot((IInventory)par1InventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.addSlotToContainer(new Slot((IInventory)par1InventoryPlayer, i, 8 + i * 18, 142));
            }
        }

        public void addCraftingToCrafters(ICrafting par1ICrafting) {
            super.addCraftingToCrafters(par1ICrafting);
            par1ICrafting.sendProgressBarUpdate((Container)this, 0, this.furnace.furnaceCookTime);
            par1ICrafting.sendProgressBarUpdate((Container)this, 1, this.furnace.powerLevel);
        }

        public void detectAndSendChanges() {
            super.detectAndSendChanges();
            for (int i = 0; i < this.crafters.size(); ++i) {
                ICrafting icrafting = (ICrafting)this.crafters.get(i);
                if (this.lastCookTime != this.furnace.furnaceCookTime) {
                    icrafting.sendProgressBarUpdate((Container)this, 0, this.furnace.furnaceCookTime);
                }
                if (this.lastPowerLevel == this.furnace.powerLevel) continue;
                icrafting.sendProgressBarUpdate((Container)this, 1, this.furnace.powerLevel);
            }
            this.lastCookTime = this.furnace.furnaceCookTime;
            this.lastPowerLevel = this.furnace.powerLevel;
        }

        @SideOnly(value=Side.CLIENT)
        public void updateProgressBar(int par1, int par2) {
            if (par1 == 0) {
                this.furnace.furnaceCookTime = par2;
            }
            if (par1 == 1) {
                this.furnace.powerLevel = par2;
            }
        }

        public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
            return this.furnace.isUseableByPlayer(par1EntityPlayer);
        }

        public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
            ItemStack itemstack = null;
            Slot slot = (Slot)this.inventorySlots.get(slotIndex);
            if (slot != null && slot.getHasStack()) {
                ItemStack itemstack1 = slot.getStack();
                itemstack = itemstack1.copy();
                if (slotIndex >= 3 && slotIndex <= 6) {
                    if (!this.mergeItemStack(itemstack1, 7, 43, true)) {
                        return null;
                    }
                    slot.onSlotChange(itemstack1, itemstack);
                } else if (slotIndex != 1 && slotIndex != 0 && slotIndex != 2 ? (FurnaceRecipes.smelting().getSmeltingResult(itemstack1) != null ? !this.mergeItemStack(itemstack1, 0, 2, false) : (Witchery.Items.GENERIC.itemEmptyClayJar.isMatch(itemstack1) ? !this.mergeItemStack(itemstack1, 2, 3, false) : (slotIndex >= 7 && slotIndex < 34 ? !this.mergeItemStack(itemstack1, 34, 43, false) : slotIndex >= 34 && slotIndex < 43 && !this.mergeItemStack(itemstack1, 7, 34, false)))) : !this.mergeItemStack(itemstack1, 7, 43, false)) {
                    return null;
                }
                if (itemstack1.stackSize == 0) {
                    slot.putStack((ItemStack)null);
                } else {
                    slot.onSlotChanged();
                }
                if (itemstack1.stackSize == itemstack.stackSize) {
                    return null;
                }
                slot.onPickupFromSlot(player, itemstack1);
            }
            return itemstack;
        }
    }

    public static class TileEntityDistillery
    extends TileEntityBase
    implements ISidedInventory {
        private ItemStack[] furnaceItemStacks = new ItemStack[7];
        public int currentItemBurnTime;
        public int furnaceCookTime;
        public int powerLevel;
        static final int COOK_TIME = 800;
        Coord powerSourceCoord;
        static final int POWER_SOURCE_RADIUS = 16;
        static final float POWER_PER_TICK = 0.6f;
        private long lastUpdate = 0L;
        private boolean needUpdate = false;
        private static final int THROTTLE = 20;
        private static final int[] slots_top = new int[]{0, 1, 2};
        private static final int[] slots_bottom = new int[]{0, 1, 2};
        private static final int[] slots_sides = new int[]{0, 1, 2, 3, 4, 5, 6};

        public int getSizeInventory() {
            return this.furnaceItemStacks.length;
        }

        public ItemStack getStackInSlot(int par1) {
            return this.furnaceItemStacks[par1];
        }

        public ItemStack decrStackSize(int par1, int par2) {
            if (this.furnaceItemStacks[par1] != null) {
                if (this.furnaceItemStacks[par1].stackSize <= par2) {
                    ItemStack itemstack = this.furnaceItemStacks[par1];
                    this.furnaceItemStacks[par1] = null;
                    return itemstack;
                }
                ItemStack itemstack = this.furnaceItemStacks[par1].splitStack(par2);
                if (this.furnaceItemStacks[par1].stackSize == 0) {
                    this.furnaceItemStacks[par1] = null;
                }
                return itemstack;
            }
            return null;
        }

        public ItemStack getStackInSlotOnClosing(int par1) {
            if (this.furnaceItemStacks[par1] != null) {
                ItemStack itemstack = this.furnaceItemStacks[par1];
                this.furnaceItemStacks[par1] = null;
                return itemstack;
            }
            return null;
        }

        public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
            this.furnaceItemStacks[par1] = par2ItemStack;
            if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit()) {
                par2ItemStack.stackSize = this.getInventoryStackLimit();
            }
        }

        public String getInventoryName() {
            return this.getBlockType().getLocalizedName();
        }

        public boolean hasCustomInventoryName() {
            return true;
        }

        public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
            super.readFromNBT(par1NBTTagCompound);
            NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items", 10);
            this.furnaceItemStacks = new ItemStack[this.getSizeInventory()];
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                byte b0 = nbttagcompound1.getByte("Slot");
                if (b0 < 0 || b0 >= this.furnaceItemStacks.length) continue;
                this.furnaceItemStacks[b0] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
            }
            this.furnaceCookTime = par1NBTTagCompound.getShort("CookTime");
        }

        public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
            super.writeToNBT(par1NBTTagCompound);
            par1NBTTagCompound.setShort("CookTime", (short)this.furnaceCookTime);
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
                if (this.furnaceItemStacks[i] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i);
                this.furnaceItemStacks[i].writeToNBT(nbttagcompound1);
                nbttaglist.appendTag((NBTBase)nbttagcompound1);
            }
            par1NBTTagCompound.setTag("Items", (NBTBase)nbttaglist);
        }

        public int getInventoryStackLimit() {
            return 64;
        }

        @SideOnly(value=Side.CLIENT)
        public int getCookProgressScaled(int par1) {
            return this.furnaceCookTime * par1 / 800;
        }

        IPowerSource getPowerSource() {
            if (this.powerSourceCoord == null || this.ticks % 100L == 0L) {
                return this.findNewPowerSource();
            }
            TileEntity tileEntity = this.powerSourceCoord.getBlockTileEntity(this.worldObj);
            if (!(tileEntity instanceof BlockAltar.TileEntityAltar)) {
                return this.findNewPowerSource();
            }
            BlockAltar.TileEntityAltar altarTileEntity = (BlockAltar.TileEntityAltar)tileEntity;
            if (!altarTileEntity.isValid()) {
                return this.findNewPowerSource();
            }
            return altarTileEntity;
        }

        private IPowerSource findNewPowerSource() {
            ArrayList<PowerSources.RelativePowerSource> sources = PowerSources.instance() != null ? PowerSources.instance().get(this.worldObj, new Coord(this), 16) : null;
            return sources != null && sources.size() > 0 ? ((PowerSources.RelativePowerSource)sources.get(0)).source() : null;
        }

        @Override
        public void updateEntity() {
            super.updateEntity();
            boolean flag1 = false;
            if (!this.worldObj.isRemote) {
                boolean powered;
                boolean cooking = this.furnaceCookTime > 0;
                boolean bl = powered = this.powerLevel > 0;
                if (this.canSmelt()) {
                    IPowerSource powerSource = this.getPowerSource();
                    this.powerSourceCoord = powerSource != null && !powerSource.isLocationEqual(this.powerSourceCoord) ? powerSource.getLocation() : null;
                    int n = this.powerLevel = powerSource == null ? 0 : 1;
                    if (powerSource != null && powerSource.consumePower(0.6f)) {
                        ++this.furnaceCookTime;
                        if (this.furnaceCookTime == 800) {
                            this.furnaceCookTime = 0;
                            this.smeltItem();
                            flag1 = true;
                        }
                    } else {
                        this.powerLevel = 0;
                    }
                } else {
                    if (this.ticks % 40L == 0L) {
                        IPowerSource powerSource = this.getPowerSource();
                        if (powerSource != null && !powerSource.isLocationEqual(this.powerSourceCoord)) {
                            this.powerSourceCoord = powerSource.getLocation();
                        }
                        this.powerLevel = powerSource == null ? 0 : 1;
                    }
                    this.furnaceCookTime = 0;
                }
                if (cooking != this.furnaceCookTime > 0) {
                    BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                    this.lastUpdate = this.ticks;
                    this.needUpdate = false;
                } else if (powered != this.powerLevel > 0) {
                    if (this.ticks - this.lastUpdate > 20L) {
                        BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                        this.lastUpdate = this.ticks;
                        this.needUpdate = false;
                    } else {
                        this.needUpdate = true;
                    }
                } else if (this.needUpdate && this.ticks - this.lastUpdate > 20L) {
                    BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                    this.lastUpdate = this.ticks;
                    this.needUpdate = false;
                }
                if (flag1) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }

        private boolean canSmelt() {
            DistilleryRecipes.DistilleryRecipe recipe = this.getActiveRecipe();
            if (recipe == null) {
                return false;
            }
            ItemStack[] itemstacks = recipe.getOutputs();
            for (int i = 0; i < itemstacks.length; ++i) {
                int newSize;
                ItemStack current = this.furnaceItemStacks[i + 3];
                if (itemstacks[i] == null || current == null || !current.isItemEqual(itemstacks[i]) || (newSize = current.stackSize + itemstacks[i].stackSize) <= this.getInventoryStackLimit() && newSize <= current.getMaxStackSize()) continue;
                return false;
            }
            return true;
        }

        public DistilleryRecipes.DistilleryRecipe getActiveRecipe() {
            if (this.furnaceItemStacks[0] == null && this.furnaceItemStacks[1] == null) {
                return null;
            }
            DistilleryRecipes.DistilleryRecipe recipe = DistilleryRecipes.instance().getDistillingResult(this.furnaceItemStacks[0], this.furnaceItemStacks[1], this.furnaceItemStacks[2]);
            return recipe;
        }

        public void smeltItem() {
            if (this.canSmelt()) {
                DistilleryRecipes.DistilleryRecipe recipe = DistilleryRecipes.instance().getDistillingResult(this.furnaceItemStacks[0], this.furnaceItemStacks[1], this.furnaceItemStacks[2]);
                ItemStack[] itemstacks = recipe.getOutputs();
                for (int i = 0; i < itemstacks.length; ++i) {
                    int furnaceIndex = i + 3;
                    if (itemstacks[i] == null) continue;
                    if (this.furnaceItemStacks[furnaceIndex] == null) {
                        this.furnaceItemStacks[furnaceIndex] = itemstacks[i].copy();
                        continue;
                    }
                    if (!this.furnaceItemStacks[furnaceIndex].isItemEqual(itemstacks[i])) continue;
                    this.furnaceItemStacks[furnaceIndex].stackSize += itemstacks[i].stackSize;
                }
                if (this.furnaceItemStacks[0] != null) {
                    --this.furnaceItemStacks[0].stackSize;
                    if (this.furnaceItemStacks[0].stackSize <= 0) {
                        this.furnaceItemStacks[0] = null;
                    }
                }
                if (this.furnaceItemStacks[1] != null) {
                    --this.furnaceItemStacks[1].stackSize;
                    if (this.furnaceItemStacks[1].stackSize <= 0) {
                        this.furnaceItemStacks[1] = null;
                    }
                }
                if (this.furnaceItemStacks[2] != null) {
                    this.furnaceItemStacks[2].stackSize -= recipe.getJars();
                    if (this.furnaceItemStacks[2].stackSize <= 0) {
                        this.furnaceItemStacks[2] = null;
                    }
                }
            }
        }

        public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
            return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : par1EntityPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
        }

        public void openInventory() {
        }

        public void closeInventory() {
        }

        public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
            if (slot > 3) {
                return false;
            }
            if (slot == 2) {
                return Witchery.Items.GENERIC.itemEmptyClayJar.isMatch(itemstack);
            }
            return !Witchery.Items.GENERIC.itemEmptyClayJar.isMatch(itemstack);
        }

        public int[] getAccessibleSlotsFromSide(int side) {
            return BlockSide.BOTTOM.isEqual(side) ? slots_bottom : (BlockSide.TOP.isEqual(side) ? slots_top : slots_sides);
        }

        public boolean canInsertItem(int slot, ItemStack itemstack, int par3) {
            return this.isItemValidForSlot(slot, itemstack);
        }

        public boolean canExtractItem(int slot, ItemStack itemstack, int side) {
            return side != 0 && side != 1 && (slot == 3 || slot == 4 || slot == 5 || slot == 6);
        }

        public Packet getDescriptionPacket() {
            NBTTagCompound nbtTag = new NBTTagCompound();
            this.writeToNBT(nbtTag);
            return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, nbtTag);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
            super.onDataPacket(net, packet);
            this.readFromNBT(packet.func_148857_g());
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }
}

