/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.blocks.BlockWitchesOven;
import com.emoniph.witchery.util.ParticleEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFumeFunnel
extends BlockBaseContainer {
    private final boolean filtered;

    public BlockFumeFunnel(boolean filtered) {
        super(Material.iron, TileEntityFumeFunnel.class);
        this.registerTileEntity = !filtered;
        this.filtered = filtered;
        this.setHardness(3.5f);
        this.setStepSound(soundTypeMetal);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean onBlockActivated(World world, int posX, int posY, int posZ, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.isRemote) {
            return true;
        }
        int meta = world.getBlockMetadata(posX, posY, posZ);
        switch (meta) {
            case 2: 
            case 3: {
                if (BlockWitchesOven.isOven(world.getBlock(posX + 1, posY, posZ))) {
                    ++posX;
                    break;
                }
                if (BlockWitchesOven.isOven(world.getBlock(posX - 1, posY, posZ))) {
                    --posX;
                    break;
                }
                if (!BlockWitchesOven.isOven(world.getBlock(posX, posY - 1, posZ))) break;
                --posY;
                break;
            }
            case 4: 
            case 5: {
                if (BlockWitchesOven.isOven(world.getBlock(posX, posY, posZ + 1))) {
                    ++posZ;
                    break;
                }
                if (BlockWitchesOven.isOven(world.getBlock(posX, posY, posZ - 1))) {
                    --posZ;
                    break;
                }
                if (!BlockWitchesOven.isOven(world.getBlock(posX, posY - 1, posZ))) break;
                --posY;
            }
        }
        if (world.getTileEntity(posX, posY, posZ) instanceof BlockWitchesOven.TileEntityWitchesOven) {
            player.openGui((Object)Witchery.instance, 2, world, posX, posY, posZ);
        }
        return true;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4, 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 1) {
            double d0 = (float)x + 0.45f;
            double d1 = (float)y + 0.4f;
            double d2 = (float)z + 0.5f;
            world.spawnParticle(ParticleEffect.SMOKE.toString(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static class TileEntityFumeFunnel
    extends TileEntity {
        public boolean canUpdate() {
            return false;
        }
    }
}

