/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.entity.EntityVampire;
import com.emoniph.witchery.ritual.rites.RiteProtectionCircleRepulsive;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGarlicGarland
extends BlockBaseContainer {
    public BlockGarlicGarland() {
        super(Material.circuits, TileEntityGarlicGarland.class);
        this.registerWithCreateTab = true;
        this.setHardness(0.2f);
    }

    public int getRenderType() {
        return -1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return super.canBlockStay(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int side = world.getBlockMetadata(x, y, z);
        float minY = 0.8f;
        float maxY = 1.0f;
        float minX = 0.0f;
        float maxX = 0.15f;
        float minZ = 0.1f;
        float maxZ = 0.9f;
        if (side == 2) {
            this.setBlockBounds(0.1f, 0.8f, 1.0f, 0.9f, 1.0f, 0.85f);
        } else if (side == 3) {
            this.setBlockBounds(0.100000024f, 0.8f, 0.0f, 0.9f, 1.0f, 0.15f);
        } else if (side == 4) {
            this.setBlockBounds(1.0f, 0.8f, 0.1f, 0.85f, 1.0f, 0.9f);
        } else if (side == 5) {
            this.setBlockBounds(0.0f, (float)y + 0.8f, 0.1f, 0.15f, 1.0f, 0.9f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (!world.isRemote && entity instanceof EntityVampire) {
            RiteProtectionCircleRepulsive.push(world, entity, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z);
        } else if (world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.capabilities.isCreativeMode && ExtendedPlayer.get((EntityPlayer)entity).isVampire()) {
                RiteProtectionCircleRepulsive.push(world, entity, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, false);
            }
        }
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int facing = MathHelper.floor_double((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            world.setBlockMetadataWithNotify(x, y, z, 2, 2);
        } else if (facing == 1) {
            world.setBlockMetadataWithNotify(x, y, z, 5, 2);
        } else if (facing == 2) {
            world.setBlockMetadataWithNotify(x, y, z, 3, 2);
        } else if (facing == 3) {
            world.setBlockMetadataWithNotify(x, y, z, 4, 2);
        }
    }

    public static class TileEntityGarlicGarland
    extends TileEntity {
        public boolean canUpdate() {
            return false;
        }
    }
}

