/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.infusion.Infusion;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.ChatUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStatueGoddess
extends BlockBaseContainer {
    public BlockStatueGoddess() {
        super(Material.rock, TileEntityStatueGoddess.class);
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setHardness(2.5f);
        this.setStepSound(soundTypeStone);
        this.setBlockBounds(0.0f, 0.0f, 0.1f, 1.0f, 2.0f, 0.9f);
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4, 2);
        }
        if (!par1World.isRemote && par5EntityLivingBase instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par5EntityLivingBase;
            TileEntityStatueGoddess tile = BlockUtil.getTileEntity((IBlockAccess)par1World, par2, par3, par4, TileEntityStatueGoddess.class);
            if (tile != null) {
                tile.setOwner(player.getCommandSenderName());
            }
        }
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        TileEntityStatueGoddess tile;
        if (!world.isRemote && (tile = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityStatueGoddess.class)) != null && (player.capabilities.isCreativeMode || player.getCommandSenderName().equals(tile.getOwner()) && player.isSneaking())) {
            int dy = y;
            while (world.getBlock(x, dy, z) == this) {
                world.setBlockToAir(x, dy, z);
                world.spawnEntityInWorld((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)dy, 0.5 + (double)z, new ItemStack((Block)this)));
                ++dy;
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (!world.isRemote) {
            NBTTagCompound nbtTag = Infusion.getNBT((Entity)player);
            if (nbtTag != null && (nbtTag.hasKey("witcheryCursed") || nbtTag.hasKey("witcheryInsanity") || nbtTag.hasKey("witcherySinking") || nbtTag.hasKey("witcheryOverheating") || nbtTag.hasKey("witcheryWakingNightmare"))) {
                if (nbtTag.hasKey("witcheryCursed")) {
                    nbtTag.removeTag("witcheryCursed");
                    ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)player, "tile.witcheryStatusGoddess.curemisfortune", new Object[0]);
                }
                if (nbtTag.hasKey("witcheryInsanity")) {
                    nbtTag.removeTag("witcheryInsanity");
                    ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)player, "tile.witcheryStatusGoddess.cureinsanity", new Object[0]);
                }
                if (nbtTag.hasKey("witcherySinking")) {
                    nbtTag.removeTag("witcherySinking");
                    ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)player, "tile.witcheryStatusGoddess.curesinking", new Object[0]);
                    Infusion.syncPlayer(world, player);
                }
                if (nbtTag.hasKey("witcheryOverheating")) {
                    nbtTag.removeTag("witcheryOverheating");
                    ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)player, "tile.witcheryStatusGoddess.cureoverheating", new Object[0]);
                }
                if (nbtTag.hasKey("witcheryWakingNightmare")) {
                    nbtTag.removeTag("witcheryWakingNightmare");
                    ChatUtil.sendTranslated(EnumChatFormatting.BLUE, (ICommandSender)player, "tile.witcheryStatusGoddess.curenightmare", new Object[0]);
                }
                if (player.isPotionActive(Potion.poison)) {
                    player.removePotionEffect(Potion.poison.id);
                }
                if (player.isPotionActive(Potion.weakness)) {
                    player.removePotionEffect(Potion.weakness.id);
                }
                if (player.isPotionActive(Potion.blindness)) {
                    player.removePotionEffect(Potion.blindness.id);
                }
                if (player.isPotionActive(Potion.digSlowdown)) {
                    player.removePotionEffect(Potion.digSlowdown.id);
                }
                if (player.isPotionActive(Potion.moveSlowdown)) {
                    player.removePotionEffect(Potion.moveSlowdown.id);
                }
                ParticleEffect.INSTANT_SPELL.send(SoundEffect.RANDOM_FIZZ, (Entity)player, 1.0, 2.0, 8);
            } else {
                SoundEffect.NOTE_SNARE.playAtPlayer(world, player);
            }
            return true;
        }
        return super.onBlockActivated(world, x, y, z, player, par6, par7, par8, par9);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon("stone");
    }

    public static class TileEntityStatueGoddess
    extends TileEntity {
        private static final String OWNER_KEY = "WITCPlacer";
        private String owner;

        public boolean canUpdate() {
            return false;
        }

        public void setOwner(String username) {
            this.owner = username;
        }

        public String getOwner() {
            return this.owner != null ? this.owner : "";
        }

        public void writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            nbtTag.setString(OWNER_KEY, this.getOwner());
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            super.readFromNBT(nbtTag);
            this.owner = nbtTag.hasKey(OWNER_KEY) ? nbtTag.getString(OWNER_KEY) : "";
        }
    }
}

