/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.blocks;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.util.BlockUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWitchDoor
extends BlockDoor {
    public BlockWitchDoor() {
        super(Material.wood);
        this.disableStatsThunk();
        this.setStepSound(Block.soundTypeWood);
    }

    public Block setBlockName(String blockName) {
        BlockUtil.registerBlock((Block)this, blockName);
        return super.setBlockName(blockName);
    }

    public void breakBlock(World world, int posX, int posY, int posZ, Block block, int metadata) {
        if (block == Witchery.Blocks.DOOR_ALDER) {
            int i1 = this.func_150012_g((IBlockAccess)world, posX, posY, posZ);
            if ((i1 & 8) != 0) {
                --posY;
            }
            this.notifyNeighborsOfBlockChange(world, posX, posY, posZ);
        }
        super.breakBlock(world, posX, posY, posZ, block, metadata);
    }

    public boolean onBlockActivated(World world, int posX, int posY, int posZ, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (this == Witchery.Blocks.DOOR_ALDER) {
            boolean result = super.onBlockActivated(world, posX, posY, posZ, player, par6, par7, par8, par9);
            int i1 = this.func_150012_g((IBlockAccess)world, posX, posY, posZ);
            if ((i1 & 8) != 0) {
                --posY;
            }
            this.notifyNeighborsOfBlockChange(world, posX, posY, posZ);
            return result;
        }
        if (this.hasKeyForDoor(world, posX, posY, posZ, player)) {
            return super.onBlockActivated(world, posX, posY, posZ, player, par6, par7, par8, par9);
        }
        return false;
    }

    public void onBlockHarvested(World world, int posX, int posY, int posZ, int par5, EntityPlayer player) {
        if (this == Witchery.Blocks.DOOR_ROWAN) {
            ItemStack stack = this.hasKeyForDoor(world, posX, posY, posZ, player) ? Witchery.Items.GENERIC.itemDoorRowan.createStack() : new ItemStack(Items.stick, 24);
            float f = 0.7f;
            double d0 = (double)(world.rand.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(world.rand.nextFloat() * 0.7f) + (double)0.15f;
            double d2 = (double)(world.rand.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityitem = new EntityItem(world, (double)posX + d0, (double)posY + d1, (double)posZ + d2, stack);
            entityitem.delayBeforeCanPickup = 10;
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)entityitem);
            }
        }
        super.onBlockHarvested(world, posX, posY, posZ, par5, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this == Witchery.Blocks.DOOR_ROWAN) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            return drops;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    private boolean hasKeyForDoor(World world, int posX, int posY, int posZ, EntityPlayer player) {
        for (int slot = 0; slot < player.inventory.mainInventory.length; ++slot) {
            NBTTagList keyList;
            ItemStack itemstack = player.inventory.mainInventory[slot];
            if (itemstack == null) continue;
            NBTTagCompound nbtTag = itemstack.getTagCompound();
            if (itemstack == null || nbtTag == null) continue;
            int i1 = this.func_150012_g((IBlockAccess)world, posX, posY, posZ);
            if (Witchery.Items.GENERIC.itemDoorKey.isMatch(itemstack)) {
                if (!nbtTag.hasKey("doorX") || !nbtTag.hasKey("doorY") || !nbtTag.hasKey("doorZ")) continue;
                int doorX = nbtTag.getInteger("doorX");
                int doorY = nbtTag.getInteger("doorY") + ((i1 & 8) != 0 ? 1 : 0);
                int doorZ = nbtTag.getInteger("doorZ");
                if (doorX != posX || doorY != posY || doorZ != posZ || nbtTag.hasKey("doorD") && nbtTag.getInteger("doorD") != world.provider.dimensionId) continue;
                return true;
            }
            if (!Witchery.Items.GENERIC.itemDoorKeyring.isMatch(itemstack) || !nbtTag.hasKey("doorKeys") || (keyList = nbtTag.getTagList("doorKeys", 10)) == null) continue;
            for (int i = 0; i < keyList.tagCount(); ++i) {
                NBTTagCompound keyTag = keyList.getCompoundTagAt(i);
                if (keyTag == null || !keyTag.hasKey("doorX") || !keyTag.hasKey("doorY") || !keyTag.hasKey("doorZ")) continue;
                int doorX = keyTag.getInteger("doorX");
                int doorY = keyTag.getInteger("doorY") + ((i1 & 8) != 0 ? 1 : 0);
                int doorZ = keyTag.getInteger("doorZ");
                if (doorX != posX || doorY != posY || doorZ != posZ || keyTag.hasKey("doorD") && keyTag.getInteger("doorD") != world.provider.dimensionId) continue;
                return true;
            }
        }
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) == 0) {
            boolean flag = false;
            if (world.getBlock(x, y + 1, z) != this) {
                world.setBlockToAir(x, y, z);
                flag = true;
            }
            if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
                // empty if block
            }
            if (flag) {
                if (!world.isRemote) {
                    this.dropBlockAsItem(world, x, y, z, l, 0);
                }
            } else {
                boolean flag1;
                boolean bl = flag1 = world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z);
                if ((flag1 || block.canProvidePower()) && block != this) {
                    this.func_150014_a(world, x, y, z, flag1);
                }
            }
        } else {
            super.onNeighborBlockChange(world, x, y, z, block);
        }
    }

    protected void dropBlockAsItem(World world, int x, int y, int z, ItemStack stack) {
        super.dropBlockAsItem(world, x, y, z, stack);
    }

    public boolean onBlockActivatedNormally(World world, int posX, int posY, int posZ, EntityPlayer player, int par6, float par7, float par8, float par9) {
        boolean result = super.onBlockActivated(world, posX, posY, posZ, player, par6, par7, par8, par9);
        if (this == Witchery.Blocks.DOOR_ALDER) {
            int i1 = this.func_150012_g((IBlockAccess)world, posX, posY, posZ);
            if ((i1 & 8) != 0) {
                --posY;
            }
            this.notifyNeighborsOfBlockChange(world, posX, posY, posZ);
        }
        return result;
    }

    private void notifyNeighborsOfBlockChange(World world, int posX, int posY, int posZ) {
        world.notifyBlocksOfNeighborChange(posX, posY, posZ, (Block)this);
        world.notifyBlocksOfNeighborChange(posX, posY - 1, posZ, (Block)this);
    }

    public Block disableStatsThunk() {
        return this.disableStats();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        if (block == Witchery.Blocks.DOOR_ALDER) {
            return Witchery.Items.GENERIC.itemDoorAlder.createStack();
        }
        return Witchery.Items.GENERIC.itemDoorRowan.createStack();
    }

    public void func_150014_a(World world, int x, int y, int z, boolean par5) {
        if (this != Witchery.Blocks.DOOR_ALDER && !par5) {
            super.func_150014_a(world, x, y, z, par5);
        }
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        if (this == Witchery.Blocks.DOOR_ALDER) {
            return this.func_150015_f(world, x, y, z) ? 15 : 0;
        }
        return super.isProvidingWeakPower(world, x, y, z, side);
    }

    public int isProvidingStrongPower(IBlockAccess par1IBlockAccess, int posX, int posY, int posZ, int side) {
        if (this == Witchery.Blocks.DOOR_ALDER) {
            return side == 1 ? this.isProvidingWeakPower(par1IBlockAccess, posX, posY, posZ, side) : 0;
        }
        return super.isProvidingStrongPower(par1IBlockAccess, posX, posY, posZ, side);
    }

    public boolean canProvidePower() {
        return this == Witchery.Blocks.DOOR_ALDER;
    }

    public Item getItemDropped(int metadata, Random rand, int fortune) {
        return (metadata & 8) != 0 ? null : Witchery.Items.GENERIC;
    }

    public int damageDropped(int metadata) {
        return (metadata & 8) != 0 ? 0 : (this == Witchery.Blocks.DOOR_ALDER ? Witchery.Items.GENERIC.itemDoorAlder.damageValue : Witchery.Items.GENERIC.itemDoorRowan.damageValue);
    }
}

