/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockBaseContainer;
import com.emoniph.witchery.brewing.EffectLevelCounter;
import com.emoniph.witchery.brewing.ModifierYield;
import com.emoniph.witchery.brewing.TileEntityCauldron;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.brewing.action.BrewAction;
import com.emoniph.witchery.client.particle.BubblesFX;
import com.emoniph.witchery.client.particle.NaturePowerFX;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.IPowerSource;
import com.emoniph.witchery.common.PowerSources;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockCauldron
extends BlockBaseContainer {
    public BlockCauldron() {
        super(Material.iron, TileEntityCauldron.class);
        this.setHardness(2.0f);
        this.setStepSound(soundTypeMetal);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.85f, 1.0f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        float f = 0.0625f;
        return AxisAlignedBB.getBoundingBox((double)((float)x + 0.0625f), (double)y, (double)((float)z + 0.0625f), (double)((float)(x + 1) - 0.0625f), (double)((float)(y + 1) - 0.0625f), (double)((float)(z + 1) - 0.0625f));
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        TileEntityCauldron cauldron = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCauldron.class);
        if (cauldron != null && cauldron.isBoiling()) {
            double zPos;
            double xPos;
            double width;
            int i;
            double yPos = 0.2 + cauldron.getPercentFilled() * 0.5;
            int color = cauldron.getColor();
            if (color == -1) {
                color = 3432410;
            } else if (rand.nextInt(5) == 0) {
                world.playSound((double)x, (double)y, (double)z, "witchery:random.blop", 0.8f + rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f, false);
            }
            float red = (float)(color >>> 16 & 0xFF) / 256.0f;
            float green = (float)(color >>> 8 & 0xFF) / 256.0f;
            float blue = (float)(color & 0xFF) / 256.0f;
            for (i = 0; i < 2; ++i) {
                width = 0.6;
                xPos = 0.2 + rand.nextDouble() * 0.6;
                zPos = 0.2 + rand.nextDouble() * 0.6;
                BubblesFX sparkle = new BubblesFX(world, (double)x + xPos, (double)y + yPos, (double)z + zPos);
                sparkle.setScale(0.4f);
                if (rand.nextInt(4) == 0) {
                    sparkle.setGravity(-0.02f);
                    sparkle.setCanMove(true);
                    sparkle.setMaxAge(15 + rand.nextInt(10));
                } else {
                    sparkle.setGravity(0.0f);
                    sparkle.setCanMove(false);
                    sparkle.setMaxAge(10 + rand.nextInt(10));
                }
                sparkle.setRBGColorF(red, green, blue);
                sparkle.setAlphaF(0.2f);
                Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)sparkle);
            }
            if (cauldron.isPowered()) {
                for (i = 0; i < 1 + Math.min(cauldron.getRitualSeconds(), 5); ++i) {
                    width = 0.4;
                    xPos = 0.3 + rand.nextDouble() * 0.4;
                    zPos = 0.3 + rand.nextDouble() * 0.4;
                    double d0 = (double)x + xPos;
                    double d1 = (double)y + yPos;
                    double d2 = (double)z + zPos;
                    NaturePowerFX sparkle = new NaturePowerFX(world, d0, d1, d2);
                    sparkle.setCircling(cauldron.isRitualInProgress());
                    sparkle.setScale(0.6f);
                    sparkle.setGravity(0.25f);
                    sparkle.setCanMove(true);
                    double maxSpeed = 0.04;
                    double doubleSpeed = 0.08;
                    sparkle.setVelocity(rand.nextDouble() * 0.08 - 0.04, rand.nextDouble() * 0.05 + 0.08, rand.nextDouble() * 0.08 - 0.04);
                    sparkle.setMaxAge(25 + rand.nextInt(cauldron.isRitualInProgress() ? 10 : 10));
                    float maxColorShift = 0.2f;
                    float doubleColorShift = maxColorShift * 2.0f;
                    float colorshiftR = rand.nextFloat() * doubleColorShift - maxColorShift;
                    float colorshiftG = rand.nextFloat() * doubleColorShift - maxColorShift;
                    float colorshiftB = rand.nextFloat() * doubleColorShift - maxColorShift;
                    sparkle.setRBGColorF(red + colorshiftR, green + colorshiftG, blue + colorshiftB);
                    sparkle.setAlphaF(0.1f);
                    Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)sparkle);
                }
            }
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        TileEntityCauldron cauldron;
        if (!world.isRemote && entity instanceof EntityItem && (cauldron = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCauldron.class)) != null) {
            EntityItem itemEntity = (EntityItem)entity;
            if (cauldron.isFilled()) {
                BrewAction brewAction;
                if (Witchery.Items.GENERIC.itemGypsum.isMatch(itemEntity.getEntityItem())) {
                    entity.setDead();
                    SoundEffect.RANDOM_FIZZ.playAt(world, (double)x + 0.5, (double)y + 0.6, (double)z + 0.5, 1.0f, 2.0f);
                    ParticleEffect.SMOKE.send(SoundEffect.NONE, world, (double)x + 0.5, (double)y + 0.6, (double)z + 0.5, 0.5, 1.0, 8);
                    cauldron.drain(ForgeDirection.UNKNOWN, cauldron.getLiquidQuantity(), true);
                    cauldron.markBlockForUpdate(true);
                } else if (Witchery.Items.GENERIC.itemQuicklime.isMatch(itemEntity.getEntityItem())) {
                    EntityPlayer nearestPlayer = EntityUtil.findNearestEntityWithinAABB(world, EntityPlayer.class, entity.boundingBox.expand(5.0, 5.0, 5.0), entity);
                    if (nearestPlayer != null && cauldron.explodeBrew(nearestPlayer)) {
                        ParticleEffect.SMOKE.send(SoundEffect.NONE, world, (double)x + 0.5, (double)y + 0.6, (double)z + 0.5, 0.5, 1.0, 8);
                        cauldron.drain(ForgeDirection.UNKNOWN, cauldron.getLiquidQuantity(), true);
                        entity.setDead();
                        cauldron.markBlockForUpdate(true);
                    }
                } else if (cauldron.isBoiling() && (brewAction = WitcheryBrewRegistry.INSTANCE.getActionForItemStack(itemEntity.getEntityItem())) != null && cauldron.addItem(brewAction, itemEntity.getEntityItem())) {
                    Item containerItem = itemEntity.getEntityItem().getItem().getContainerItem();
                    if (containerItem != null) {
                        EntityUtil.spawnEntityInWorld(world, (Entity)new EntityItem(world, 0.5 + (double)x, 1.0 + (double)y, 0.5 + (double)z, new ItemStack(containerItem)));
                    }
                    entity.setDead();
                    ParticleEffect.SPLASH.send(SoundEffect.WATER_SPLASH, world, (double)x + 0.5, (double)y + 0.6, (double)z + 0.5, 0.5, 0.5, 8);
                }
            }
        }
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int side) {
        TileEntityCauldron cauldron = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCauldron.class);
        int signal = 0;
        if (cauldron != null) {
            return cauldron.getRedstoneSignalStrength();
        }
        return signal;
    }

    public boolean tryFillWith(World world, int x, int y, int z, FluidStack fluidStack) {
        if (world.isRemote) {
            return true;
        }
        TileEntityCauldron cauldron = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCauldron.class);
        if (cauldron != null) {
            FluidStack fluidStackToFill = new FluidStack(FluidRegistry.WATER.getID(), 1000);
            if (cauldron.canFill(ForgeDirection.UNKNOWN, fluidStack.getFluid())) {
                int quantity = cauldron.fill(ForgeDirection.UNKNOWN, fluidStack, true);
                fluidStack.amount -= quantity;
                if (fluidStack.amount < 0) {
                    fluidStack.amount = 0;
                }
                if (quantity > 0) {
                    SoundEffect.WATER_SWIM.playAt(world, x, y, z);
                    cauldron.markBlockForUpdate(true);
                }
                return quantity > 0;
            }
        }
        return false;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        TileEntityCauldron cauldron = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCauldron.class);
        ItemStack heldStack = player.getHeldItem();
        if (cauldron != null && heldStack != null) {
            FluidStack fluidStackToFill = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldStack);
            if (fluidStackToFill != null) {
                int quantityFilled;
                NBTTagCompound nBTTagCompound = fluidStackToFill.tag = heldStack.hasTagCompound() ? (NBTTagCompound)heldStack.getTagCompound().copy() : null;
                if (cauldron.canFill(ForgeDirection.UNKNOWN, fluidStackToFill.getFluid()) && (quantityFilled = cauldron.fill(ForgeDirection.UNKNOWN, fluidStackToFill, true)) != 0) {
                    if (!player.capabilities.isCreativeMode) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockCauldron.consumeItem(heldStack));
                    }
                    SoundEffect.WATER_SWIM.playAtPlayer(world, player);
                    cauldron.markBlockForUpdate(true);
                }
                return true;
            }
            if (heldStack.getItem() == Witchery.Items.BREW_ENDLESS_WATER) {
                if (this.tryFillWith(world, x, y, z, new FluidStack(FluidRegistry.WATER, 3000))) {
                    heldStack.damageItem(1, (EntityLivingBase)player);
                }
                return true;
            }
            FluidStack fluidStackInCauldron = cauldron.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (fluidStackInCauldron != null) {
                int drainAmount;
                ItemStack filledBucketStack = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidStackInCauldron, (ItemStack)heldStack);
                FluidStack fluidStackToEmpty = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledBucketStack);
                if (fluidStackToEmpty != null) {
                    if (fluidStackInCauldron.tag != null) {
                        filledBucketStack.setTagCompound((NBTTagCompound)fluidStackInCauldron.tag.copy());
                    }
                    if (!player.capabilities.isCreativeMode) {
                        if (heldStack.stackSize > 1) {
                            if (!player.inventory.addItemStackToInventory(filledBucketStack)) {
                                return false;
                            }
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockCauldron.consumeItem(heldStack));
                        } else {
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockCauldron.consumeItem(heldStack));
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, filledBucketStack);
                        }
                    }
                    cauldron.drain(ForgeDirection.UNKNOWN, fluidStackToEmpty.amount, true);
                    SoundEffect.WATER_SWIM.playAtPlayer(world, player);
                    world.markBlockForUpdate(x, y, z);
                    cauldron.markBlockForUpdate(true);
                } else if (heldStack.getItem() == Items.glass_bottle && (drainAmount = this.getDrainAmount(player, fluidStackInCauldron.tag)) > 0 && cauldron.isPowered() && cauldron.isBoiling()) {
                    boolean enoughLiquid;
                    NBTTagCompound nbtFluid = (NBTTagCompound)fluidStackInCauldron.tag.copy();
                    boolean bl = enoughLiquid = drainAmount <= cauldron.getLiquidQuantity();
                    if (enoughLiquid) {
                        IPowerSource source = PowerSources.findClosestPowerSource(cauldron);
                        int power = cauldron.getPower();
                        if (power == 0 || source != null && source.consumePower(cauldron.getPower())) {
                            cauldron.drain(ForgeDirection.UNKNOWN, Math.min(drainAmount, cauldron.getLiquidQuantity()), true);
                            SoundEffect.WATER_SWIM.playAtPlayer(world, player);
                            cauldron.markBlockForUpdate(true);
                            this.processSkillChanges(player, fluidStackInCauldron.tag);
                            ItemStack brewStack = new ItemStack(Witchery.Items.BREW);
                            brewStack.setTagCompound(nbtFluid);
                            if (heldStack.stackSize > 1) {
                                if (player.inventory.addItemStackToInventory(brewStack)) {
                                    player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockCauldron.consumeItem(heldStack));
                                    EntityUtil.syncInventory(player);
                                    return false;
                                }
                                return true;
                            }
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, BlockCauldron.consumeItem(heldStack));
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, brewStack);
                            EntityUtil.syncInventory(player);
                            return true;
                        }
                    }
                }
            }
        }
        return super.onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public ItemStack fillBottleFromCauldron(World world, int x, int y, int z, int drainAmount) {
        FluidStack fluidStackInCauldron;
        TileEntityCauldron cauldron = BlockUtil.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCauldron.class);
        if (cauldron != null && (fluidStackInCauldron = cauldron.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid) != null && drainAmount > 0 && cauldron.isPowered() && cauldron.isBoiling()) {
            NBTTagCompound nbtFluid = (NBTTagCompound)fluidStackInCauldron.tag.copy();
            boolean enoughLiquid = drainAmount <= cauldron.getLiquidQuantity();
            cauldron.drain(ForgeDirection.UNKNOWN, Math.min(drainAmount, cauldron.getLiquidQuantity()), true);
            SoundEffect.WATER_SWIM.playAt(world, x, y, z);
            cauldron.markBlockForUpdate(true);
            if (enoughLiquid) {
                ItemStack brewStack = new ItemStack(Witchery.Items.BREW);
                brewStack.setTagCompound(nbtFluid);
                return brewStack;
            }
        }
        return null;
    }

    private void processSkillChanges(EntityPlayer player, NBTTagCompound nbtBrew) {
        int currentLevel;
        EffectLevelCounter levels;
        ExtendedPlayer props = ExtendedPlayer.get(player);
        if (props != null && (levels = WitcheryBrewRegistry.INSTANCE.getBrewLevel(nbtBrew)).canIncreasePlayerSkill(currentLevel = props.getSkillPotionBottling())) {
            props.increaseSkillPotionBottling();
        }
    }

    private int getDrainAmount(EntityPlayer player, NBTTagCompound nbtFluid) {
        ModifierYield yieldModifier = WitcheryBrewRegistry.INSTANCE.getYieldModifier(nbtFluid);
        int[][] yieldLevels = new int[][]{{1, 3000}, {2, 1500}, {3, 1000}, {4, 750}, {5, 600}, {6, 500}, {8, 375}, {10, 300}, {15, 200}, {30, 100}};
        int yield = 0;
        ExtendedPlayer props = ExtendedPlayer.get(player);
        if (props != null) {
            boolean familiarLevel;
            int levelSkill = props.getSkillPotionBottling() / 30;
            PotionEffect potionEffect = player.getActivePotionEffect(Witchery.Potions.BREWING_EXPERT);
            int levelPotion = potionEffect != null ? potionEffect.getAmplifier() + 1 : 0;
            int gearLevel = 0;
            ItemStack headItem = player.inventory.armorItemInSlot(3);
            gearLevel += Witchery.Items.WITCH_HAT.isHatWorn(player) ? 1 : 0;
            gearLevel += Witchery.Items.BABAS_HAT.isHatWorn(player) ? 2 : 0;
            gearLevel += Witchery.Items.WITCH_ROBES.isRobeWorn(player) ? 1 : 0;
            gearLevel += Witchery.Items.NECROMANCERS_ROBES.isRobeWorn(player) ? 1 : 0;
            boolean bl = familiarLevel = Familiar.hasActiveBrewMasteryFamiliar(player);
            if (levelSkill == 0) {
                yield = 0;
            } else if (levelSkill == 1) {
                yield = gearLevel >= 1 || levelPotion >= 1 ? 2 : 1;
            } else if (levelSkill >= 2) {
                yield = gearLevel >= 3 && levelPotion >= 3 && familiarLevel >= true ? 9 : (gearLevel >= 2 && levelPotion >= 3 && familiarLevel >= true ? 8 : (gearLevel >= 2 && levelPotion >= 3 ? 7 : (gearLevel >= 2 && levelPotion >= 2 ? 6 : (gearLevel >= 2 && levelPotion >= 1 ? 5 : (gearLevel >= 2 || levelPotion >= 1 ? 4 : (gearLevel >= 1 || levelPotion >= 1 ? 3 : 2))))));
            }
        }
        return yieldLevels[Math.max(yield - yieldModifier.getYieldModification(), 0)][1];
    }

    private static ItemStack consumeItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            if (stack.getItem().hasContainerItem(stack)) {
                return stack.getItem().getContainerItem(stack);
            }
            return null;
        }
        stack.splitStack(1);
        return stack;
    }
}

