/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.brewing.Dispersal;
import com.emoniph.witchery.brewing.ModifiersEffect;
import com.emoniph.witchery.brewing.ModifiersImpact;
import com.emoniph.witchery.brewing.ModifiersRitual;
import com.emoniph.witchery.brewing.RitualStatus;
import com.emoniph.witchery.brewing.TileEntityCursedBlock;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.familiar.Familiar;
import com.emoniph.witchery.util.BlockProtect;
import com.emoniph.witchery.util.BlockUtil;
import com.emoniph.witchery.util.Coord;
import com.emoniph.witchery.util.EntityPosition;
import com.emoniph.witchery.util.EntityUtil;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class DispersalTriggered
extends Dispersal {
    @Override
    public void onImpactSplashPotion(World world, NBTTagCompound nbtBrew, MovingObjectPosition mop, ModifiersImpact modifiers) {
        Coord coord = new Coord(mop, modifiers.impactPosition, true);
        boolean replaceable = BlockProtect.checkModsForBreakOK(world, coord.x, coord.y, coord.z, (EntityLivingBase)modifiers.thrower);
        if (replaceable) {
            TileEntityCursedBlock tile;
            Block block = coord.getBlock(world);
            if (block == Blocks.stone_button) {
                Witchery.Blocks.CURSED_BUTTON_STONE.replaceButton(world, coord.x, coord.y, coord.z, modifiers, nbtBrew);
                return;
            }
            if (block == Blocks.wooden_button) {
                Witchery.Blocks.CURSED_BUTTON_WOOD.replaceButton(world, coord.x, coord.y, coord.z, modifiers, nbtBrew);
                return;
            }
            if (block == Blocks.lever) {
                Witchery.Blocks.CURSED_LEVER.replaceButton(world, coord.x, coord.y, coord.z, modifiers, nbtBrew);
                return;
            }
            if (block.hasTileEntity(coord.getBlockMetadata(world)) && (tile = BlockUtil.getTileEntity((IBlockAccess)world, coord.x, coord.y, coord.z, TileEntityCursedBlock.class)) != null) {
                tile.updateCurse(modifiers, nbtBrew);
            }
            if ((block = (coord = new Coord(mop, modifiers.impactPosition, false)).getBlock(world)) == Blocks.wooden_pressure_plate) {
                Witchery.Blocks.CURSED_WOODEN_PRESSURE_PLATE.replaceButton(world, coord.x, coord.y, coord.z, modifiers, nbtBrew);
            } else if (block == Blocks.stone_pressure_plate) {
                Witchery.Blocks.CURSED_STONE_PRESSURE_PLATE.replaceButton(world, coord.x, coord.y, coord.z, modifiers, nbtBrew);
            } else if (block == Witchery.Blocks.SNOW_PRESSURE_PLATE) {
                Witchery.Blocks.CURSED_SNOW_PRESSURE_PLATE.replaceButton(world, coord.x, coord.y, coord.z, modifiers, nbtBrew);
            } else if (block == Blocks.wooden_door) {
                Witchery.Blocks.CURSED_WOODEN_DOOR.replaceButton(world, coord.x, coord.y, coord.z, modifiers, nbtBrew);
            } else if (block.hasTileEntity(coord.getBlockMetadata(world))) {
                TileEntityCursedBlock tile2;
                int i1;
                int y = coord.y;
                if (block == Witchery.Blocks.CURSED_WOODEN_DOOR && ((i1 = ((BlockDoor)Blocks.wooden_door).func_150012_g((IBlockAccess)world, coord.x, coord.y, coord.z)) & 8) != 0) {
                    --y;
                }
                if ((tile2 = BlockUtil.getTileEntity((IBlockAccess)world, coord.x, y, coord.z, TileEntityCursedBlock.class)) != null) {
                    tile2.updateCurse(modifiers, nbtBrew);
                }
            }
        }
    }

    @Override
    public String getUnlocalizedName() {
        return "witchery:brew.dispersal.triggered";
    }

    @Override
    public RitualStatus onUpdateRitual(World world, int x, int y, int z, NBTTagCompound nbtBrew, ModifiersRitual modifiers, ModifiersImpact impactModifiers) {
        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)x, (double)(y + 1), (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1));
        List items = world.getEntitiesWithinAABB(EntityItem.class, bounds);
        for (EntityItem item : items) {
            NBTTagCompound nbtCurse;
            ItemStack stack = item.getEntityItem();
            if (stack == null) continue;
            if (stack.stackSize > 1) {
                stack = stack.splitStack(1);
                EntityItem newEntity = new EntityItem(item.worldObj, item.posX, item.posY, item.posZ, stack);
                world.spawnEntityInWorld((Entity)newEntity);
            }
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            NBTTagCompound nbtRoot = stack.getTagCompound();
            AxisAlignedBB playerBounds = bounds.expand(3.0, 3.0, 3.0);
            List players = world.getEntitiesWithinAABB(EntityPlayer.class, playerBounds);
            boolean catNear = false;
            for (EntityPlayer player : players) {
                if (!Familiar.hasActiveCurseMasteryFamiliar(player)) continue;
                catNear = true;
                break;
            }
            if (nbtRoot.hasKey("WITCCurse") && ((NBTTagCompound)nbtRoot.getCompoundTag("WITCCurse").getTag("Curse")).getTagList("Items", 10).equals((Object)nbtBrew.getTagList("Items", 10))) {
                nbtCurse = nbtRoot.getCompoundTag("WITCCurse");
                nbtCurse.setInteger("Count", nbtCurse.getInteger("Count") + (catNear ? 2 : 1));
            } else {
                nbtCurse = new NBTTagCompound();
                nbtCurse.setTag("Curse", nbtBrew.copy());
                nbtCurse.setInteger("Count", catNear ? 2 : 1);
                nbtRoot.setTag("WITCCurse", (NBTBase)nbtCurse);
            }
            ParticleEffect.EXPLODE.send(SoundEffect.RANDOM_ORB, (Entity)item, 0.5, 0.5, 16);
            return RitualStatus.COMPLETE;
        }
        return RitualStatus.FAILED;
    }

    public static class EventHooks {
        @SubscribeEvent
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (!event.entityPlayer.worldObj.isRemote && (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && event.entityPlayer.getHeldItem() != null && event.entityPlayer.getHeldItem().hasTagCompound() && event.entityPlayer.getHeldItem().getTagCompound().hasKey("WITCCurse")) {
                NBTTagCompound root = event.entityPlayer.getHeldItem().getTagCompound().getCompoundTag("WITCCurse");
                NBTTagCompound tag = root.getCompoundTag("Curse");
                int charges = root.getInteger("Count");
                long delay = root.getLong("Delay");
                if (delay == 0L || MinecraftServer.getSystemTimeMillis() > delay) {
                    if (charges > 0) {
                        WitcheryBrewRegistry.INSTANCE.applyToEntity(event.entityPlayer.worldObj, (EntityLivingBase)event.entityPlayer, tag, new ModifiersEffect(1.0, 1.0, false, new EntityPosition((Entity)event.entityPlayer), false, 0, EntityUtil.playerOrFake(event.entityPlayer.worldObj, (EntityLivingBase)null)));
                        ParticleEffect.SPELL_COLORED.send(SoundEffect.RANDOM_POP, (Entity)event.entityPlayer, 1.0, 1.0, 16);
                        --charges;
                    }
                    if (charges > 0) {
                        root.setInteger("Count", charges);
                        root.setLong("Delay", MinecraftServer.getSystemTimeMillis() + 5000L);
                    } else {
                        event.entityPlayer.getHeldItem().getTagCompound().removeTag("WITCCurse");
                        if (event.entityPlayer.getHeldItem().getTagCompound().hasNoTags()) {
                            event.entityPlayer.getHeldItem().setTagCompound(null);
                        }
                    }
                }
            }
        }
    }
}

