/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing;

import com.emoniph.witchery.brewing.EntityThrowableBase;
import com.emoniph.witchery.brewing.ModifiersImpact;
import com.emoniph.witchery.brewing.WitcheryBrewRegistry;
import com.emoniph.witchery.util.EntityPosition;
import com.emoniph.witchery.util.EntityUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityBrew
extends EntityThrowableBase {
    private ItemStack brewStack;
    private int color;
    private boolean isSpell;

    public EntityBrew(World world) {
        super(world);
    }

    public EntityBrew(World world, EntityLivingBase thrower, ItemStack brewStack, boolean isSpell) {
        super(world, thrower, isSpell ? 0.0f : -20.0f);
        this.brewStack = brewStack;
        this.setIsSpell(isSpell);
        this.setColor(WitcheryBrewRegistry.INSTANCE.getBrewColor(brewStack.getTagCompound()));
    }

    public EntityBrew(World world, double x, double y, double z, ItemStack brewStack, boolean isSpell) {
        super(world, x, y, z, isSpell ? 0.0f : -20.0f);
        this.brewStack = brewStack;
        this.setIsSpell(isSpell);
        this.setColor(WitcheryBrewRegistry.INSTANCE.getBrewColor(brewStack.getTagCompound()));
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(6, (Object)0);
        this.dataWatcher.addObject(12, (Object)0);
        super.entityInit();
    }

    protected void setColor(int color) {
        this.getDataWatcher().updateObject(6, (Object)color);
    }

    public int getColor() {
        return this.getDataWatcher().getWatchableObjectInt(6);
    }

    protected void setIsSpell(boolean spell) {
        this.getDataWatcher().updateObject(12, (Object)(spell ? (byte)1 : 0));
    }

    public boolean getIsSpell() {
        return this.getDataWatcher().getWatchableObjectByte(12) == 1;
    }

    public ItemStack getBrew() {
        return this.brewStack;
    }

    @Override
    protected float getGravityVelocity() {
        return this.getIsSpell() ? 0.0f : 0.05f;
    }

    @Override
    protected float func_70182_d() {
        return this.getIsSpell() ? 4.0f : 0.75f;
    }

    @Override
    protected float func_70183_g() {
        return this.getIsSpell() ? 0.0f : -20.0f;
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote && mop != null && WitcheryBrewRegistry.INSTANCE.impactSplashPotion(this.worldObj, this.brewStack, mop, new ModifiersImpact(new EntityPosition(this), false, 0, EntityUtil.playerOrFake(this.worldObj, this.getThrower())))) {
            this.worldObj.playAuxSFX(2002, MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ), this.getColor());
        }
        this.setDead();
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbtRoot) {
        super.readEntityFromNBT(nbtRoot);
        if (nbtRoot.hasKey("Brew", 10)) {
            this.brewStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbtRoot.getCompoundTag("Brew"));
            this.setColor(WitcheryBrewRegistry.INSTANCE.getBrewColor(this.brewStack.getTagCompound()));
            if (nbtRoot.hasKey("Spell")) {
                this.setIsSpell(nbtRoot.getBoolean("Spell"));
            }
        }
        if (this.brewStack == null) {
            this.setDead();
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbtRoot) {
        super.writeEntityToNBT(nbtRoot);
        if (this.brewStack != null) {
            nbtRoot.setTag("Brew", (NBTBase)this.brewStack.writeToNBT(new NBTTagCompound()));
            nbtRoot.setBoolean("Spell", this.getIsSpell());
        }
    }
}

