/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.IHandleLivingUpdate;
import com.emoniph.witchery.brewing.potions.IHandleRenderLiving;
import com.emoniph.witchery.brewing.potions.ModelOverlayRenderer;
import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.client.model.ModelGrotesque;
import com.emoniph.witchery.entity.EntityDemon;
import com.emoniph.witchery.ritual.rites.RiteProtectionCircleRepulsive;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.lwjgl.opengl.GL11;

public class PotionGrotesque
extends PotionBase
implements IHandleLivingUpdate,
IHandleRenderLiving {
    @SideOnly(value=Side.CLIENT)
    private static ModelGrotesque DEMON_HEAD_MODEL;
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation TEXTURE;

    public PotionGrotesque(int id, int color) {
        super(id, color);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onLivingRender(World world, EntityLivingBase entity, RenderLivingEvent.Post event, int amplifier) {
        if (DEMON_HEAD_MODEL == null) {
            DEMON_HEAD_MODEL = new ModelGrotesque();
        }
        if (TEXTURE == null) {
            TEXTURE = new ResourceLocation("witchery", "textures/entities/Demon.png");
        }
        GL11.glPushMatrix();
        Minecraft.getMinecraft().getTextureManager().bindTexture(TEXTURE);
        ModelOverlayRenderer.renderModel(event.entity, event.x, event.y, event.z, event.renderer, DEMON_HEAD_MODEL);
        GL11.glPopMatrix();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 5L == 3L) {
            float radius = 4.0f;
            float radiusSq = 16.0f;
            AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)(entity.posX - 4.0), (double)(entity.posY - 4.0), (double)(entity.posZ - 4.0), (double)(entity.posX + 4.0), (double)(entity.posY + 4.0), (double)(entity.posZ + 4.0));
            List list = world.getEntitiesWithinAABB(EntityLiving.class, bounds);
            for (EntityLiving victim : list) {
                boolean canApply = entity != victim && !(victim instanceof EntityDemon) && !(victim instanceof IBossDisplayData) && !(victim instanceof EntityGolem);
                if (!canApply || !(victim.getDistanceSqToEntity((Entity)entity) < 16.0)) continue;
                RiteProtectionCircleRepulsive.push(entity.worldObj, (Entity)victim, entity.posX, entity.posY, entity.posZ);
            }
        }
    }
}

