/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.IHandleRenderLiving;
import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import org.lwjgl.opengl.GL11;

public class PotionHellishAura
extends PotionBase
implements IHandleRenderLiving {
    public PotionHellishAura(int id, int color) {
        super(id, color);
    }

    public boolean isReady(int duration, int amplifier) {
        int frequencyFactor = 25;
        int k = frequencyFactor >> amplifier;
        return k > 0 ? duration % k == 0 : true;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        World world = entity.worldObj;
        if (!world.isRemote) {
            List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, entity.boundingBox.expand(1.5, 0.0, 1.5));
            for (EntityLivingBase otherEntity : entities) {
                if (entity == otherEntity) continue;
                otherEntity.attackEntityFrom(new EntityDamageSource(DamageSource.onFire.damageType, (Entity)entity).setFireDamage().setDamageBypassesArmor(), 1.0f);
                ParticleEffect.FLAME.send(SoundEffect.MOB_GHAST_FIREBALL, (Entity)otherEntity, otherEntity.width, otherEntity.height, 16);
                if (amplifier <= 0) continue;
                otherEntity.setFire(amplifier);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onLivingRender(World world, EntityLivingBase entity, RenderLivingEvent.Post event, int amplifier) {
        EntityLivingBase p_76977_1_ = entity;
        double p_76977_2_ = entity.posX;
        double p_76977_4_ = entity.posY;
        double p_76977_6_ = entity.posZ;
        GL11.glDisable((int)2896);
        IIcon iicon = Blocks.fire.getFireIcon(0);
        IIcon iicon1 = Blocks.fire.getFireIcon(1);
        GL11.glPushMatrix();
        float f1 = p_76977_1_.width * 1.4f;
        GL11.glScalef((float)f1, (float)f1, (float)f1);
        Tessellator tessellator = Tessellator.instance;
        float f2 = 0.5f;
        float f3 = 0.0f;
        float f4 = p_76977_1_.height / f1;
        float f5 = (float)(p_76977_1_.posY - p_76977_1_.boundingBox.minY);
        GL11.glRotatef((float)(-RenderManager.instance.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f4) * 0.02f));
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        float f6 = 0.0f;
        int i = 0;
        tessellator.startDrawingQuads();
        while (f4 > 0.0f) {
            IIcon iicon2 = i % 2 == 0 ? iicon : iicon1;
            RenderManager.instance.renderEngine.bindTexture(TextureMap.locationBlocksTexture);
            float f7 = iicon2.getMinU();
            float f8 = iicon2.getMinV();
            float f9 = iicon2.getMaxU();
            float f10 = iicon2.getMaxV();
            if (i / 2 % 2 == 0) {
                float f11 = f9;
                f9 = f7;
                f7 = f11;
            }
            tessellator.addVertexWithUV((double)(f2 - f3), (double)(0.0f - f5), (double)f6, (double)f9, (double)f10);
            tessellator.addVertexWithUV((double)(-f2 - f3), (double)(0.0f - f5), (double)f6, (double)f7, (double)f10);
            tessellator.addVertexWithUV((double)(-f2 - f3), (double)(1.4f - f5), (double)f6, (double)f7, (double)f8);
            tessellator.addVertexWithUV((double)(f2 - f3), (double)(1.4f - f5), (double)f6, (double)f9, (double)f8);
            f4 -= 0.45f;
            f5 -= 0.45f;
            f2 *= 0.9f;
            f6 += 0.03f;
            ++i;
        }
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }
}

