/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.EntityAIVillagerMateNow;
import com.emoniph.witchery.brewing.potions.EntityAIZombieMateNow;
import com.emoniph.witchery.brewing.potions.IHandleLivingUpdate;
import com.emoniph.witchery.brewing.potions.PotionBase;
import com.emoniph.witchery.util.ParticleEffect;
import com.emoniph.witchery.util.SoundEffect;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;

public class PotionLove
extends PotionBase
implements IHandleLivingUpdate {
    public PotionLove(int id, int color) {
        super(id, color);
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (!world.isRemote && world.getTotalWorldTime() % 20L == 7L) {
            if (entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (animal.getGrowingAge() >= 0 && !animal.isInLove()) {
                    animal.setGrowingAge(0);
                    animal.func_146082_f(null);
                }
            } else if (entity instanceof EntityZombie) {
                EntityZombie zombie = (EntityZombie)entity;
                if (!zombie.isChild()) {
                    for (Object obj : zombie.tasks.taskEntries) {
                        EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)obj;
                        if (!(task.action instanceof EntityAIZombieMateNow)) continue;
                        ((EntityAIZombieMateNow)task.action).beginMating();
                        return;
                    }
                    EntityAIZombieMateNow ai = new EntityAIZombieMateNow(zombie);
                    ai.beginMating();
                    zombie.tasks.addTask(1, (EntityAIBase)ai);
                }
            } else if (entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                if (!villager.isChild() && !villager.isMating()) {
                    for (Object obj : villager.tasks.taskEntries) {
                        EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)obj;
                        if (!(task.action instanceof EntityAIVillagerMateNow)) continue;
                        ((EntityAIVillagerMateNow)task.action).beginMating();
                        return;
                    }
                    EntityAIVillagerMateNow ai = new EntityAIVillagerMateNow(villager);
                    ai.beginMating();
                    villager.tasks.addTask(1, (EntityAIBase)ai);
                }
            } else if (entity instanceof EntityPlayer && world.rand.nextInt(2) == 0) {
                ParticleEffect.HEART.send(SoundEffect.NONE, world, event.entityLiving.posX, event.entityLiving.posY + 1.0, event.entityLiving.posZ, 0.6, 2.0, 16);
            }
        }
    }
}

