/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.PotionBase;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class PotionReflectProjectiles
extends PotionBase {
    public PotionReflectProjectiles(int id, int color) {
        super(id, color);
    }

    public boolean isReady(int duration, int amplifier) {
        return true;
    }

    public void performEffect(EntityLivingBase entity, int amplifier) {
        World world = entity.worldObj;
        double RADIUS = 2.0;
        double RADIUS_SQ = 4.0;
        AxisAlignedBB bounds = entity.boundingBox.expand(2.0, 2.0, 2.0);
        List projectileList = world.getEntitiesWithinAABB(IProjectile.class, bounds);
        for (IProjectile projectile : projectileList) {
            EntityArrow arrow;
            boolean isArrow = false;
            if (projectile instanceof EntityArrow) {
                arrow = (EntityArrow)projectile;
                isArrow = true;
                if (arrow.shootingEntity == entity) {
                    continue;
                }
            } else if (projectile instanceof EntityThrowable && (arrow = (EntityThrowable)projectile).getThrower() == entity) continue;
            if (!(projectile instanceof Entity)) continue;
            Entity projectileEntity = (Entity)projectile;
            projectileEntity.motionX *= -0.25 * (1.0 + (double)amplifier);
            if (projectileEntity.motionX > 0.0 || projectileEntity.motionZ > 0.0) {
                projectileEntity.motionY *= -0.25 * (1.0 + (double)amplifier);
            }
            projectileEntity.motionZ *= -0.25 * (1.0 + (double)amplifier);
            if (!isArrow) continue;
        }
    }
}

