/*
 * Decompiled with CFR 0.152.
 */
package com.emoniph.witchery.brewing.potions;

import com.emoniph.witchery.brewing.potions.IHandleLivingUpdate;
import com.emoniph.witchery.brewing.potions.PotionBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;

public class PotionSinking
extends PotionBase
implements IHandleLivingUpdate {
    public PotionSinking(int id, int color) {
        super(id, true, color);
    }

    @Override
    public void postContructInitialize() {
        this.setPermenant();
        this.setIncurable();
    }

    @Override
    public void onLivingUpdate(World world, EntityLivingBase entity, LivingEvent.LivingUpdateEvent event, int amplifier, int duration) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (world.isRemote) {
                if (player.isInWater()) {
                    if (player.motionY < -0.03 && !player.onGround) {
                        player.motionY *= 1.5 + Math.min(0.05 * (double)amplifier, 0.2);
                    } else if (!player.onGround && player.isInsideOfMaterial(Material.water) && player.motionY > 0.0) {
                        // empty if block
                    }
                } else if (!player.capabilities.isCreativeMode && player.capabilities.allowFlying && player.capabilities.isFlying) {
                    player.motionY = -0.2f;
                }
            }
        } else if (world.isRemote && world.getTotalWorldTime() % 20L == 3L && entity.isInWater()) {
            if (entity.motionY < 0.0) {
                entity.motionY *= 1.0 + Math.min(0.1 * (double)(amplifier + 2), 0.4);
            } else if (entity.motionY > 0.0) {
                entity.motionY *= 1.0 - Math.min(0.1 * (double)(amplifier + 2), 0.4);
            }
        }
    }
}

